import React from 'react';
import './App.css';

function App() {
  return (
    <div className="tracking-label">
      <div className="header">
        <div className="logo-placeholder"></div>
        <div className="company-info">
          <h1>Taxel Express Courier Limited</h1>
          <p>456 Commerce Avenue, Canary Wharf, London E14 5AB, United Kingdom</p>
          <p className="website">www.taxelexpresscourier.com</p>
        </div>
        <div className="tracking-box">
          <p>Tracking Number</p>
          <h2>TE000845489</h2>
        </div>
      </div>

      <div className="shipping-details">
        <div className="sender">
          <h3>From (Sender)</h3>
          <h4>Doreen Wong</h4>
          <p>Email: doreenwong122@gmail.com</p>
          <p>Phone: +2295003198</p>
          <p>Address: Hale Road Speke, Liverpool Merseyside, L24 1UE</p>
        </div>
        
        <div className="tracking-info">
          <p>Tracking: TE000845489</p>
          <p>Shipment Date: 12 Oct 2024</p>
          <p>Delivery Date: 13 Oct 2024</p>
        </div>

        <div className="consignee">
          <h3>To (Consignee)</h3>
          <h4>Tan Sing Choon</h4>
          <p>Email: singchoon51@gmail.com</p>
          <p>Phone: +65 97984489</p>
          <p>Address: BLK 956 14-296 Hougang st 91 Singapore 530956</p>
        </div>
      </div>

      <table className="shipment-table">
        <thead>
          <tr>
            <th>Qty</th>
            <th>Item Description</th>
            <th>Weight</th>
            <th>Shipment Cost</th>
            <th>Payment Status</th>
            <th>Status</th>
          </tr>
        </thead>
        <tbody>
          <tr>
            <td>1</td>
            <td>Wears, Gadgets, Accessories and Jewelries</td>
            <td>18 KG</td>
            <td></td>
            <td>Pending</td>
            <td><span className="processed">PROCESSED</span></td>
          </tr>
        </tbody>
      </table>

      <div className="footer">
        <div className="barcode"></div>
        <div className="comment">
          <p>Comment: The Management and Staff of Taxel Express Courier wishes to thank you for your
          patronage and kind help to serve you better. Note: you are expected to receive your package
          within 24 hours after payment.</p>
        </div>
        <div className="stamp">
          <div className="stamp-content">
            <p>12-10-2024</p>
            <p>ALWAYS ON TIME</p>
          </div>
        </div>
      </div>
    </div>
  );
}

export default App;