// Function to format date
function formatDate(date) {
    const options = { day: '2-digit', month: 'short', year: 'numeric' };
    return date.toLocaleDateString('en-GB', options).replace(',', '');
}

// Function to update dates
function updateDates() {
    const today = new Date();
    const tomorrow = new Date(today);
    tomorrow.setDate(tomorrow.getDate() + 1);

    // Update shipment and delivery dates
    document.getElementById('shipmentDate').textContent = formatDate(today);
    document.getElementById('deliveryDate').textContent = formatDate(tomorrow);
    
    // Update stamp date
    document.getElementById('stampDate').textContent = today.toLocaleDateString('en-GB', {
        day: '2-digit',
        month: '2-digit',
        year: 'numeric'
    }).replace(/\//g, '-');
}

// Initialize dates when the page loads
document.addEventListener('DOMContentLoaded', updateDates);