<?php
include '../db.php';
include '../config.php';

$shiping_cost = 0;
$clearance_cost = 0;
$total_cost = 0;

if (isset($_GET['tracking_number']) && $_GET['tracking_number'] != "") {
    $trackId = $_GET['tracking_number'];
    $sql = mysqli_query($link, "SELECT * FROM tracking WHERE tracking_number = '$trackId' ");
    if (mysqli_num_rows($sql) > 0) {
        $row = mysqli_fetch_assoc($sql);
        $senders_name = $row['sender_name'];
        $senders_contact = $row['sender_contact'];
        $senders_mail = $row['sender_email'];
        $senders_address = $row['sender_address'];
        $receivers_name = $row['receiver_name'];
        $receivers_contact = $row['receiver_contact'];
        $receivers_mail = $row['receiver_email'];
        $receivers_address = $row['receiver_address'];
        $statuss = $row['status'];
        $dispatch_l = $row['dispatch_location'];
        $dispatchh = $row['dispatch_date'];
        $deliveryy = $row['delivery_date'];
        $current_location = $row['current_location'];
        $desc = $row['pdesc'];
        $carrier = $row['carrier'];
        $carrier_ref = $row['carrier_ref'];
        $weight = $row['weight'];
        $payment_mode = $row['payment_mode'];
        $ship_mode = $row['ship_mode'];
        $quantity = $row['quantity'];
        $delivery_time = $row['delivery_time'];
        $image = $row['image'];
        $destination = $row['destination'];
        $date = $row['date'];
        $total_cost = $row['total_f'];
        $pstatus = $row['payment_mode'];

        $barcode_url = "https://barcode.tec-it.com/barcode.ashx?data=" . urlencode($trackId) . "&code=Code128";
    }

    $sqls = mysqli_query($link, "SELECT * FROM track_update WHERE track_num = '$trackId' ORDER BY track_num DESC LIMIT 1");
    if (mysqli_num_rows($sqls) > 0) {
        $rows = mysqli_fetch_assoc($sqls);
        $status = $rows['status'];
        $current_location = $rows['current_location'];
        $shiping_cost = $rows['delivery_charge'];
        $clearance_cost = $rows['total_charge'];
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $sitename ?></title>
    <style>
        * {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
            font-family: Arial, sans-serif;
        }

        body {
            background-color: #f5f5f5;
            padding: 20px;
            line-height: 1.5;
            position: relative;
        }

        .receipt-container {
            position: relative;
            max-width: 800px;
            margin: 0 auto;
        }

        .receipt-background {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background-image: url('images.jpg');
            background-size: cover;
            background-position: center;
            opacity: 0.3;
            z-index: 0;
            border-radius: 5px;
        }

        .tracking-label {
            position: relative;
            z-index: 1;
            padding: 20px;
            color: #111 !important;
        }

        .header {
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
            align-items: center;
            border-bottom: 1px solid #eee;
            padding-bottom: 15px;
            margin-bottom: 15px;
        }

        .logo-placeholder img {
            height: auto;
            max-width: 100%;
        }

        .company-info {
            flex: 1;
            padding: 0 15px;
        }

        .company-info h1 {
            font-size: 24px;
            color: #111;
            margin-bottom: 5px;
        }

        .company-info p {
            font-size: 14px;
            color: #222;
        }

        .tracking-box {
            background-color: rgba(240, 240, 240, 0.9);
            padding: 10px 15px;
            border-radius: 5px;
            text-align: center;
            min-width: 180px;
            color: #111;
        }

        .tracking-box p {
            font-size: 14px;
            margin-bottom: 5px;
        }

        .tracking-box h2 {
            font-size: 18px;
        }

        .shipping-details {
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
            margin-bottom: 20px;
        }

        .sender, .consignee, .tracking-info {
            flex: 1;
            min-width: 200px;
            margin-bottom: 15px;
            padding: 10px;
            background-color: rgba(255, 255, 255, 0.9);
            border-radius: 5px;
            color: #111;
        }

        .sender h3, .consignee h3 {
            font-size: 16px;
            margin-bottom: 10px;
            border-bottom: 1px solid #eee;
            padding-bottom: 5px;
        }

        .sender h4, .consignee h4 {
            font-size: 14px;
            margin-bottom: 5px;
        }

        .sender p, .consignee p, .tracking-info p {
            font-size: 13px;
            margin-bottom: 3px;
        }

        .shipment-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            background-color: rgba(255, 255, 255, 0.9);
            color: #111;
        }

        .shipment-table th, .shipment-table td {
            border: 1px solid #ddd;
            padding: 8px 10px;
            text-align: left;
            font-size: 13px;
        }

        .shipment-table th {
            background-color: rgba(245, 245, 245, 0.95);
        }

        .footer {
            display: flex;
            flex-wrap: wrap;
            justify-content: space-between;
            align-items: center;
            border-top: 1px solid #eee;
            padding-top: 15px;
        }

        .barcode {
            flex: 1;
            min-width: 150px;
            text-align: center;
            background-color: rgba(255, 255, 255, 0.9);
            padding: 10px;
            border-radius: 5px;
        }

        .comment {
            flex: 2;
            min-width: 300px;
            padding: 0 15px;
            font-size: 13px;
            background-color: rgba(255, 255, 255, 0.9);
            padding: 10px;
            border-radius: 5px;
            color: #111;
        }

        .stamp {
            flex: 1;
            min-width: 100px;
            text-align: right;
        }

        .stamp img {
            max-width: 100%;
            height: auto;
        }

        @media (max-width: 768px) {
            .header {
                flex-direction: column;
                align-items: flex-start;
            }

            .company-info {
                padding: 15px 0;
            }

            .tracking-box {
                margin-top: 15px;
                align-self: flex-start;
            }

            .shipping-details {
                flex-direction: column;
            }

            .sender, .consignee, .tracking-info {
                margin-bottom: 20px;
                padding: 10px;
                width: 100%;
            }

            .shipment-table {
                display: block;
                overflow-x: auto;
                white-space: nowrap;
            }

            .footer {
                flex-direction: column;
                align-items: center;
                text-align: center;
            }

            .barcode, .comment, .stamp {
                margin-bottom: 15px;
                width: 100%;
            }

            .stamp {
                order: -1;
                text-align: center;
            }

            .comment {
                min-width: 100%;
            }
        }

        @media print {
            body {
                background-color: white;
                padding: 0;
            }

            .receipt-background {
                opacity: 0.2;
            }

            .tracking-label {
                box-shadow: none;
                padding: 15px;
            }

            .sender, .consignee, .tracking-info,
            .shipment-table, .barcode, .comment {
                background-color: rgba(255, 255, 255, 0.9);
                color: #000;
            }
        }
    </style>
</head>
<body onload="window.print();">
    <div class="receipt-container">
        <div class="receipt-background"></div>
        <div class="tracking-label">
            <div class="header">
                <div class="logo-placeholder">
                    <img src="../assets/images/logo/logo-light.png" alt="" width="170">
                </div>
                <div class="company-info">
                    <h1><?php echo $sitename ?></h1>
                    <p><?php echo $site_address ?></p>
                    <p><?php echo $site_url ?></p>
                </div>
                <div class="tracking-box">
                    <p>Tracking Number</p>
                    <h2><?php echo $trackId ?></h2>
                </div>
            </div>

            <div class="shipping-details">
                <div class="sender">
                    <h3>From (Sender)</h3>
                    <h4><?php echo $senders_name ?></h4>
                    <p>Email: <?php echo $senders_mail ?></p>
                    <p>Phone: <?php echo $senders_contact ?></p>
                    <p>Address: <?php echo $senders_address ?></p>
                </div>
                
                <div class="tracking-info">
                    <p>Tracking: <?php echo $trackId ?></p>
                    <p>Shipment Date: <span id="shipmentDate"><?php echo $dispatchh ?></span></p>
                    <p>Delivery Date: <span id="deliveryDate"><?php echo $deliveryy ?></span></p>
                </div>

                <div class="consignee">
                    <h3>To (Consignee)</h3>
                    <h4><?php echo $receivers_name ?></h4>
                    <p>Email: <?php echo $receivers_mail ?></p>
                    <p>Phone: <?php echo $receivers_contact ?></p>
                    <p>Address: <?php echo $receivers_address ?></p>
                </div>
            </div>

            <table class="shipment-table">
                <thead>
                    <tr>
                        <th>Qty</th>
                        <th>Item Description</th>
                        <th>Weight</th>
                        <th>Shipment Cost</th>
                        <th>Payment Method</th>
                        <th>Status</th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td><?php echo $quantity ?></td>
                        <td><?php echo $desc ?></td>
                        <td><?php echo $weight ?> KG</td>
                        <td>$ <?php echo $total_cost ?></td>
                        <td><?php echo $pstatus ?></td>
                        <td><?php echo $statuss ?></td>
                    </tr>
                </tbody>
            </table>

            <div class="footer">
                <div class="barcode">
                    <?php if (isset($trackId)) : ?>
                        <img style="width: 150px;" src="<?php echo $barcode_url; ?>" alt="Barcode for <?php echo htmlspecialchars($trackId); ?>">
                    <?php endif; ?>
                </div>
                <div class="comment">
                    <p>Comment: The Management and Staff of <?php echo $sitename ?> wishes to thank you for your
                    patronage and kind help to serve you better. Note: you are expected to receive your package
                    within 24 hours after payment.</p>
                </div>
                <div class="stamp">
                    <img src="approved.png" alt="" width="100">
                </div>
            </div>
        </div>
    </div>
</body>
</html>
