﻿<!DOCTYPE html>
<html lang="en">
<head>
	<meta charset="utf-8">
	<title>droplet | Form Plugins</title>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="description" content="">
	<meta name="author" content="">
	
	<!-- ================== BEGIN core-css ================== -->
	<link href="assets/css/vendor.min.css" rel="stylesheet">
	<link href="assets/css/app.min.css" rel="stylesheet">
	<!-- ================== END core-css ================== -->
	
	<!-- ================== BEGIN page-css ================== -->
	<link href="assets/plugins/tag-it/css/jquery.tagit.css" rel="stylesheet">
	<link href="assets/plugins/bootstrap-datepicker/dist/css/bootstrap-datepicker.min.css" rel="stylesheet">
	<link href="assets/plugins/bootstrap-daterangepicker/daterangepicker.css" rel="stylesheet">
	<link href="assets/plugins/bootstrap-timepicker/css/bootstrap-timepicker.min.css" rel="stylesheet">
	<link href="assets/plugins/bootstrap-slider/dist/css/bootstrap-slider.min.css" rel="stylesheet">
	<link href="assets/plugins/blueimp-file-upload/css/jquery.fileupload.css" rel="stylesheet">
	<link href="assets/plugins/summernote/dist/summernote-lite.css" rel="stylesheet">
	<link href="assets/plugins/spectrum-colorpicker2/dist/spectrum.min.css" rel="stylesheet">
	<link href="assets/plugins/select-picker/dist/picker.min.css" rel="stylesheet">
	<link href="assets/plugins/jquery-typeahead/dist/jquery.typeahead.min.css" rel="stylesheet">
	<!-- ================== END page-css ================== -->

</head>
<body>
	<!-- BEGIN #app -->
	<div id="app" class="app">
		<!-- BEGIN #header -->
		<div id="header" class="app-header">
			<!-- BEGIN desktop-toggler -->
			<div class="desktop-toggler">
				<button type="button" class="menu-toggler" data-toggle-class="app-sidebar-collapsed" data-toggle-target=".app">
					<span class="bar"></span>
					<span class="bar"></span>
				</button>
			</div>
			<!-- END desktop-toggler -->
			
			<!-- BEGIN mobile-toggler -->
			<div class="mobile-toggler">
				<button type="button" class="menu-toggler" data-toggle-class="app-sidebar-mobile-toggled" data-toggle-target=".app">
					<span class="bar"></span>
					<span class="bar"></span>
				</button>
			</div>
			<!-- END mobile-toggler -->
				
			<!-- BEGIN brand -->
			<div class="brand">
				<a href="index.html" class="brand-logo">
					droplet
				</a>
			</div>
			<!-- END brand -->
			
			<!-- BEGIN menu -->
			<div class="menu">
				<div class="menu-item dropdown">
					<a href="index.html" data-toggle-class="app-header-menu-search-toggled" data-toggle-target=".app" class="menu-link">
						<div class="menu-icon"><i class="bi bi-search nav-icon"></i></div>
					</a>
				</div>
				<div class="menu-item dropdown dropdown-mobile-full">
					<a href="#" data-bs-toggle="dropdown" data-bs-display="static" class="menu-link">
						<div class="menu-icon"><i class="bi bi-grid-3x3-gap nav-icon"></i></div>
					</a>
					<div class="dropdown-menu fade dropdown-menu-end w-300px text-center p-0 mt-1 overflow-hidden">
						<div class="row gx-0 p-1 pb-0">
							<div class="col-4">
								<div class="h-100 p-1">
									<a href="email_inbox.html" class="dropdown-item p-2 rounded-2">
										<div class="position-relative pt-1">
											<i class="bi bi-circle-fill position-absolute text-primary end-0 me-2 fs-6px d-block"></i>
											<i class="bi bi-envelope fs-2 d-block text-body text-opacity-50"></i>
										</div>
										<div class="small">Inbox</div>
									</a>
								</div>
							</div>
							<div class="col-4">
								<div class="h-100 p-1">
									<a href="pos_customer_order.html" target="_blank" class="dropdown-item p-2 rounded-2">
										<div class="position-relative pt-1">
											<i class="bi bi-hdd-network fs-2 d-block text-body text-opacity-50"></i>
										</div>
										<div class="small">Pos System</div>
									</a>
								</div>
							</div>
							<div class="col-4">
								<div class="h-100 p-1">
									<a href="calendar.html" class="dropdown-item p-2 rounded-2">
										<div class="position-relative pt-1">
											<i class="bi bi-calendar4 fs-2 d-block text-body text-opacity-50"></i>
										</div>
										<div class="small">Calendar</div>
									</a>
								</div>
							</div>
						</div>
						<div class="row gx-0 p-1 pt-0">
							<div class="col-4">
								<div class="h-100 p-1">
									<a href="helper.html" class="dropdown-item p-2 rounded-2">
										<div class="position-relative pt-1">
											<i class="bi bi-terminal fs-2 d-block text-body text-opacity-50"></i>
										</div>
										<div class="small">Helper</div>
									</a>
								</div>
							</div>
							<div class="col-4">
								<div class="h-100 p-1">
									<a href="settings.html" class="dropdown-item p-2 rounded-2">
										<div class="position-relative pt-1">
											<i class="bi bi-circle-fill position-absolute text-primary end-0 me-2 fs-6px d-block"></i>
											<i class="bi bi-sliders fs-2 d-block text-body text-opacity-50"></i>
										</div>
										<div class="small">Settings</div>
									</a>
								</div>
							</div>
							<div class="col-4">
								<div class="h-100 p-1">
									<a href="widgets.html" class="dropdown-item p-2 rounded-2">
										<div class="position-relative pt-1">
											<i class="bi bi-collection-play fs-2 d-block text-body text-opacity-50"></i>
										</div>
										<div class="small">Widgets</div>
									</a>
								</div>
							</div>
						</div>
					</div>
				</div>
				<div class="menu-item dropdown dropdown-mobile-full">
					<a href="#" data-bs-toggle="dropdown" data-bs-display="static" class="menu-link">
						<div class="menu-icon"><i class="bi bi-bell nav-icon"></i></div>
						<div class="menu-badge bg-theme"></div>
					</a>
					<div class="dropdown-menu dropdown-menu-end mt-1 w-350px pt-1">
						<h6 class="dropdown-header mb-1">Notifications (5)</h6>
						<div class="dropdown-divider mt-1"></div>
						<a href="#" class="d-flex align-items-center dropdown-item text-wrap">
							<div class="fs-20px bg-primary bg-opacity-15 w-40px h-40px rounded-pill d-flex align-items-center justify-content-center">
								<i class="fa fa-box fa-lg text-primary"></i>
							</div>
							<div class="flex-1 flex-wrap ps-3">
								<div>New order received ($1,299)</div>
								<div class="small text-body text-opacity-50">just now</div>
							</div>
							<div class="ps-2 text-body text-opacity-25">
								<i class="fa fa-chevron-right"></i>
							</div>
						</a>
						<a href="#" class="d-flex align-items-center dropdown-item text-wrap">
							<div class="fs-20px bg-body w-40px h-40px rounded-pill d-flex align-items-center justify-content-center">
								<i class="fa fa-user text-body text-opacity-50"></i>
							</div>
							<div class="flex-1 flex-wrap ps-3">
								<div>3 new account created</div>
								<div class="small text-body text-opacity-50">2 minutes ago</div>
							</div>
							<div class="ps-2 text-body text-opacity-25">
								<i class="fa fa-chevron-right"></i>
							</div>
						</a>
						<a href="#" class="d-flex align-items-center dropdown-item text-wrap">
							<div class="fs-20px bg-primary bg-opacity-15 w-40px h-40px rounded-pill d-flex align-items-center justify-content-center">
								<i class="fa fa-server text-primary"></i>
							</div>
							<div class="flex-1 flex-wrap ps-3">
								<div>Setup completed</div>
								<div class="small text-body text-opacity-50">3 minutes ago</div>
							</div>
							<div class="ps-2 text-body text-opacity-25">
								<i class="fa fa-chevron-right"></i>
							</div>
						</a>
						<a href="#" class="d-flex align-items-center dropdown-item text-wrap">
							<div class="fs-20px bg-primary bg-opacity-15 w-40px h-40px rounded-pill d-flex align-items-center justify-content-center">
								<i class="fa fa-screwdriver-wrench text-primary"></i>
							</div>
							<div class="flex-1 flex-wrap ps-3">
								<div>Widget installation done</div>
								<div class="small text-body text-opacity-50">5 minutes ago</div>
							</div>
							<div class="ps-2 text-body text-opacity-25">
								<i class="fa fa-chevron-right"></i>
							</div>
						</a>
						<a href="#" class="d-flex align-items-center dropdown-item text-wrap">
							<div class="fs-20px bg-primary bg-opacity-15 w-40px h-40px rounded-pill d-flex align-items-center justify-content-center">
								<i class="fa fa-file-invoice text-primary"></i>
							</div>
							<div class="flex-1 flex-wrap ps-3">
								<div>Payment method enabled</div>
								<div class="small text-body text-opacity-50">10 minutes ago</div>
							</div>
							<div class="ps-2 text-body text-opacity-25">
								<i class="fa fa-chevron-right"></i>
							</div>
						</a>
						<div class="dropdown-divider"></div>
						<div class="text-center">
							<a href="#" class="text-decoration-none fw-bold">see all</a>
						</div>
					</div>
				</div>
				<div class="menu-item dropdown dropdown-mobile-full">
					<a href="#" data-bs-toggle="dropdown" data-bs-display="static" class="menu-link">
						<div class="menu-img online">
							<span class="menu-img-bg" style="background-image: url(assets/img/user/user.jpg)"></span>
						</div>
						<div class="menu-text d d-none"><span class="__cf_email__" data-cfemail="e0959385928e818d85a08183838f958e94ce838f8d">[email&#160;protected]</span></div>
					</a>
					<div class="dropdown-menu dropdown-menu-end me-lg-3 mt-1 w-200px">
						<a class="dropdown-item d-flex align-items-center" href="profile.html"><i class="far fa-user fa-fw fa-lg me-3"></i> Profile</a>
						<a class="dropdown-item d-flex align-items-center" href="email_inbox.html"><i class="far fa-envelope fa-fw fa-lg me-3"></i> Inbox</a>
						<a class="dropdown-item d-flex align-items-center" href="calendar.html"><i class="far fa-calendar fa-fw fa-lg me-3"></i> Calendar</a>
						<a class="dropdown-item d-flex align-items-center" href="settings.html"><i class="fa fa-sliders fa-fw fa-lg me-3"></i> Settings</a>
						<div class="dropdown-divider"></div>
						<a class="dropdown-item d-flex align-items-center" href="page_login.html"><i class="fa fa-arrow-right-from-bracket fa-fw fa-lg me-3"></i> Logout</a>
					</div>
				</div>
			</div>
			<!-- END menu -->
			
			<!-- BEGIN menu-search -->
			<form class="menu-search" method="POST" name="header_search_form">
				<div class="menu-search-container">
					<div class="menu-search-icon"><i class="bi bi-search"></i></div>
					<div class="menu-search-input">
						<input type="text" class="form-control form-control-lg" placeholder="Search menu...">
					</div>
					<div class="menu-search-icon">
						<a href="#" data-toggle-class="app-header-menu-search-toggled" data-toggle-target=".app"><i class="bi bi-x-lg"></i></a>
					</div>
				</div>
			</form>
			<!-- END menu-search -->
		</div>
		<!-- END #header -->
		
		<!-- BEGIN #sidebar -->
		<div id="sidebar" class="app-sidebar">
			<!-- BEGIN scrollbar -->
			<div class="app-sidebar-content" data-scrollbar="true" data-height="100%">
				<!-- BEGIN menu -->
				<div class="menu">
					<div class="menu-profile">
						<a href="javascript:;" class="menu-profile-link" data-bs-toggle="dropdown">
							<div class="menu-profile-cover with-shadow"></div>
							<div class="menu-profile-image">
								<div class="menu-profile-img" style="background-image: url(assets/img/user/user.jpg)"></div>
							</div>
							<div class="menu-profile-info">
								<div class="d-flex align-items-center">
									<div class="flex-grow-1 fw-bold">
										Administrator
									</div>
									<div class="ms-auto"><i class="fa fa-chevron-down"></i></div>
								</div>
								<small><span class="__cf_email__" data-cfemail="c3b6b0a6b1ada2aea683a2a0a0acb6adb7eda0acae">[email&#160;protected]</span></small>
							</div>
						</a>
						<div class="dropdown-menu dropdown-menu-end me-lg-3 mt-1 w-200px">
							<a class="dropdown-item d-flex align-items-center" href="profile.html"><i class="far fa-user fa-fw fa-lg me-3"></i> Profile</a>
							<a class="dropdown-item d-flex align-items-center" href="email_inbox.html"><i class="far fa-envelope fa-fw fa-lg me-3"></i> Inbox</a>
							<a class="dropdown-item d-flex align-items-center" href="calendar.html"><i class="far fa-calendar fa-fw fa-lg me-3"></i> Calendar</a>
							<a class="dropdown-item d-flex align-items-center" href="settings.html"><i class="fa fa-sliders fa-fw fa-lg me-3"></i> Settings</a>
							<div class="dropdown-divider"></div>
							<a class="dropdown-item d-flex align-items-center" href="page_login.html"><i class="fa fa-arrow-right-from-bracket fa-fw fa-lg me-3"></i> Logout</a>
						</div>
					</div>
					<div class="menu-header">Navigation</div>
					<div class="menu-item">
						<a href="index.html" class="menu-link">
							<span class="menu-icon"><i class="fa fa-qrcode"></i></span>
							<span class="menu-text">Dashboard</span>
						</a>
					</div>
					<div class="menu-item">
						<a href="analytics.html" class="menu-link">
							<span class="menu-icon"><i class="fa fa-chart-bar"></i></span>
							<span class="menu-text">Analytics</span>
						</a>
					</div>
					<div class="menu-item has-sub">
						<a href="#" class="menu-link">
							<span class="menu-icon">
								<i class="fa fa-envelope-open-text"></i>
							</span>
							<span class="menu-text">Email</span>
							<span class="menu-caret"><b class="caret"></b></span>
						</a>
						<div class="menu-submenu">
							<div class="menu-item">
								<a href="email_inbox.html" class="menu-link">
									<span class="menu-text">Inbox</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="email_compose.html" class="menu-link">
									<span class="menu-text">Compose</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="email_detail.html" class="menu-link">
									<span class="menu-text">Detail</span>
								</a>
							</div>
						</div>
					</div>
					<div class="menu-header">Components</div>
					<div class="menu-item">
						<a href="widgets.html" class="menu-link">
							<span class="menu-icon"><i class="fa fa-gem"></i></span>
							<span class="menu-text">Widgets</span>
						</a>
					</div>
					<div class="menu-item has-sub">
						<a href="javascript:;" class="menu-link">
							<div class="menu-icon">
								<i class="fa fa-microchip"></i>
							</div>
							<div class="menu-text d-flex align-items-center">AI Studio</div> 
							<span class="menu-caret"><b class="caret"></b></span>
						</a>
						<div class="menu-submenu">
							<div class="menu-item">
								<a href="ai_chat.html" class="menu-link">
									<div class="menu-text">AI Chat</div>
								</a>
							</div>
							<div class="menu-item">
								<a href="ai_image_generator.html" class="menu-link">
									<div class="menu-text">AI Image Generator</div>
								</a>
							</div>
						</div>
					</div>
					<div class="menu-item has-sub">
						<a href="javascript:;" class="menu-link">
							<div class="menu-icon">
								<i class="fa fa-wallet"></i>
							</div>
							<div class="menu-text d-flex align-items-center">POS System</div> 
							<span class="menu-caret"><b class="caret"></b></span>
						</a>
						<div class="menu-submenu">
							<div class="menu-item">
								<a href="pos_customer_order.html" target="_blank" class="menu-link">
									<div class="menu-text">Customer Order</div>
								</a>
							</div>
							<div class="menu-item">
								<a href="pos_kitchen_order.html" target="_blank" class="menu-link">
									<div class="menu-text">Kitchen Order</div>
								</a>
							</div>
							<div class="menu-item">
								<a href="pos_counter_checkout.html" target="_blank" class="menu-link">
									<div class="menu-text">Counter Checkout</div>
								</a>
							</div>
							<div class="menu-item">
								<a href="pos_table_booking.html" target="_blank" class="menu-link">
									<div class="menu-text">Table Booking</div>
								</a>
							</div>
							<div class="menu-item">
								<a href="pos_menu_stock.html" target="_blank" class="menu-link">
									<div class="menu-text">Menu Stock</div>
								</a>
							</div>
						</div>
					</div>
					<div class="menu-item has-sub">
						<a href="#" class="menu-link">
							<span class="menu-icon"><i class="fa fa-palette"></i></span>
							<span class="menu-text">UI Kits</span> 
							<span class="menu-caret"><b class="caret"></b></span>
						</a>
						<div class="menu-submenu">
							<div class="menu-item">
								<a href="ui_bootstrap.html" class="menu-link">
									<span class="menu-text">Bootstrap</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="ui_buttons.html" class="menu-link">
									<span class="menu-text">Buttons</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="ui_card.html" class="menu-link">
									<span class="menu-text">Card</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="ui_icons.html" class="menu-link">
									<span class="menu-text">Icons</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="ui_modal_notification.html" class="menu-link">
									<span class="menu-text">Modal & Notification</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="ui_typography.html" class="menu-link">
									<span class="menu-text">Typography</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="ui_tabs_accordions.html" class="menu-link">
									<span class="menu-text">Tabs & Accordions</span>
								</a>
							</div>
						</div>
					</div>
					<div class="menu-item has-sub active">
						<a href="#" class="menu-link">
							<span class="menu-icon"><i class="fa fa-font"></i></span>
							<span class="menu-text">Forms</span> 
							<span class="menu-caret"><b class="caret"></b></span>
						</a>
						<div class="menu-submenu">
							<div class="menu-item">
								<a href="form_elements.html" class="menu-link">
									<span class="menu-text">Form Elements</span>
								</a>
							</div>
							<div class="menu-item active">
								<a href="form_plugins.html" class="menu-link">
									<span class="menu-text">Form Plugins</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="form_wizards.html" class="menu-link">
									<span class="menu-text">Wizards</span>
								</a>
							</div>
						</div>
					</div>
					<div class="menu-item has-sub">
						<a href="#" class="menu-link">
							<span class="menu-icon"><i class="fa fa-border-all"></i></span>
							<span class="menu-text">Tables</span>
							<span class="menu-caret"><b class="caret"></b></span>
						</a>
						<div class="menu-submenu">
							<div class="menu-item">
								<a href="table_elements.html" class="menu-link">
									<span class="menu-text">Table Elements</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="table_plugins.html" class="menu-link">
									<span class="menu-text">Table Plugins</span>
								</a>
							</div>
						</div>
					</div>
					<div class="menu-item has-sub">
						<a href="#" class="menu-link">
							<span class="menu-icon"><i class="fa fa-chart-pie"></i></span>
							<span class="menu-text">Charts</span>
							<span class="menu-caret"><b class="caret"></b></span>
						</a>
						<div class="menu-submenu">
							<div class="menu-item">
								<a href="chart_js.html" class="menu-link">
									<span class="menu-text">Chart.js</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="chart_apex.html" class="menu-link">
									<span class="menu-text">Apexcharts.js</span>
								</a>
							</div>
						</div>
					</div>
					<div class="menu-item">
						<a href="map.html" class="menu-link">
							<span class="menu-icon"><i class="fa fa-earth-asia"></i></span>
							<span class="menu-text">Map</span>
						</a>
					</div>
					<div class="menu-item has-sub">
						<a href="#" class="menu-link">
							<span class="menu-icon"><i class="fa fa-clone"></i></span>
							<span class="menu-text">Layout</span>
							<span class="menu-caret"><b class="caret"></b></span>
						</a>
						<div class="menu-submenu">
							<div class="menu-item">
								<a href="layout_starter.html" class="menu-link">
									<span class="menu-text">Starter Page</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="layout_fixed_footer.html" class="menu-link">
									<span class="menu-text">Fixed Footer</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="layout_full_height.html" class="menu-link">
									<span class="menu-text">Full Height</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="layout_full_width.html" class="menu-link">
									<span class="menu-text">Full Width</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="layout_boxed_layout.html" class="menu-link">
									<span class="menu-text">Boxed Layout</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="layout_collapsed_sidebar.html" class="menu-link">
									<span class="menu-text">Collapsed Sidebar</span>
								</a>
							</div>
						</div>
					</div>
					<div class="menu-item has-sub">
						<a href="#" class="menu-link">
							<span class="menu-icon"><i class="fa fa-file-code"></i></span>
							<span class="menu-text">Pages</span>
							<span class="menu-caret"><b class="caret"></b></span>
						</a>
						<div class="menu-submenu">
							<div class="menu-item">
								<a href="page_scrum_board.html" class="menu-link">
									<span class="menu-text">Scrum Board</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="page_products.html" class="menu-link">
									<span class="menu-text">Products</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="page_product_details.html" class="menu-link">
									<span class="menu-text">Product Details</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="page_orders.html" class="menu-link">
									<span class="menu-text">Orders</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="page_order_details.html" class="menu-link">
									<span class="menu-text">Order Details</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="page_gallery.html" class="menu-link">
									<span class="menu-text">Gallery</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="page_search_results.html" class="menu-link">
									<span class="menu-text">Search Results</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="page_coming_soon.html" class="menu-link">
									<span class="menu-text">Coming Soon Page</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="page_404_error.html" class="menu-link">
									<span class="menu-text">404 Error Page</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="page_login.html" class="menu-link">
									<span class="menu-text">Login</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="page_register.html" class="menu-link">
									<span class="menu-text">Register</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="page_messenger.html" class="menu-link">
									<span class="menu-text">Messenger</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="page_data_management.html" class="menu-link">
									<span class="menu-text">Data Management</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="page_file_manager.html" class="menu-link">
									<span class="menu-text">File Manager</span>
								</a>
							</div>
							<div class="menu-item">
								<a href="page_pricing.html" class="menu-link">
									<span class="menu-text">Pricing Page</span>
								</a>
							</div>
						</div>
					</div>
					<div class="menu-item">
						<a href="landing.html" class="menu-link">
							<span class="menu-icon"><i class="fab fa-slack"></i></span>
							<span class="menu-text">Landing Page</span>
						</a>
					</div>
					<div class="menu-header">Users</div>
					<div class="menu-item">
						<a href="profile.html" class="menu-link">
							<span class="menu-icon"><i class="fa fa-user"></i></span>
							<span class="menu-text">Profile</span>
						</a>
					</div>
					<div class="menu-item">
						<a href="calendar.html" class="menu-link">
							<span class="menu-icon"><i class="fa fa-calendar-day"></i></span>
							<span class="menu-text">Calendar</span>
						</a>
					</div>
					<div class="menu-item">
						<a href="settings.html" class="menu-link">
							<span class="menu-icon"><i class="fa fa-sliders"></i></span>
							<span class="menu-text">Settings</span>
						</a>
					</div>
					<div class="menu-item">
						<a href="helper.html" class="menu-link">
							<span class="menu-icon"><i class="fa fa-info-circle"></i></span>
							<span class="menu-text">Helper</span>
						</a>
					</div>
				</div>
				<!-- END menu -->
				<div class="p-3 mt-auto">
					<a href="documentation/index.html" target="_blank" class="btn d-block btn-theme fs-13px fw-semibold rounded-pill">
						<i class="fa fa-code-branch me-2 ms-n2 opacity-5"></i> Documentation
					</a>
				</div>
			</div>
			<!-- END scrollbar -->
		</div>
		<!-- END #sidebar -->
			
		<!-- BEGIN mobile-sidebar-backdrop -->
		<button class="app-sidebar-mobile-backdrop" data-toggle-target=".app" data-toggle-class="app-sidebar-mobile-toggled"></button>
		<!-- END mobile-sidebar-backdrop -->
		
		<!-- BEGIN #content -->
		<div id="content" class="app-content">
			<!-- BEGIN container -->
			<div class="container">
				<!-- BEGIN row -->
				<div class="row justify-content-center">
					<!-- BEGIN col-10 -->
					<div class="col-xl-10">
						<!-- BEGIN row -->
						<div class="row">
							<!-- BEGIN col-9 -->
							<div class="col-xl-9">
								<ul class="breadcrumb">
									<li class="breadcrumb-item"><a href="#">Forms</a></li>
									<li class="breadcrumb-item active">Form Plugins</li>
								</ul>
								
								<h1 class="page-header">
									Form Plugins <small>page header description goes here...</small>
								</h1>
								
								<hr class="mb-4">
								
								<!-- BEGIN #bootstrapDatepicker -->
								<div id="bootstrapDatepicker" class="mb-5">
									<h4>Bootstrap datepicker</h4>
									<p>Bootstrap datepicker provides a flexible datepicker widget in the Bootstrap style. Please read the <a href="https://bootstrap-datepicker.readthedocs.io/en/latest/index.html" target="_blank">official documentation</a> for the full list of options.</p>
									<div class="card">
										<div class="card-body pb-2">
											<form>
												<div class="row">
													<div class="col-xl-6">
														<div class="mb-3">
															<label class="form-label">Default <span class="text-danger">*</span></label>
															<input type="text" class="form-control" id="datepicker-default" placeholder="dd/mm/yyyy">
														</div>
													</div>
													<div class="col-xl-6">
														<div class="mb-3">
															<label class="form-label">Component <span class="text-danger">*</span></label>
															<div class="input-group">
																<input type="text" class="form-control" id="datepicker-component" placeholder="with input group addon">
																<label class="input-group-text" for="datepicker-component"><i class="fa fa-calendar"></i></label>
															</div>
														</div>
													</div>
													<div class="col-xl-6">
														<div class="mb-3">
															<label class="form-label">Range <span class="text-danger">*</span></label>
															<div class="input-group input-daterange" id="datepicker-range">
																<input type="text" class="form-control" name="start" placeholder="start date">
																<span class="input-group-text">to</span>
																<input type="text" class="form-control" name="end" placeholder="end date">
															</div>
														</div>
													</div>
												</div>
											</form>
										</div>
										<div class="hljs-container rounded-bottom">
											<pre><code class="xml" data-url="assets/data/form-plugins/code-1.json"></code></pre>
										</div>
									</div>
								</div>
								<!-- END #bootstrapDatepicker -->
								
								<!-- BEGIN #bootstrapDaterangepicker -->
								<div id="bootstrapDaterangepicker" class="mb-5">
									<h4>Bootstrap daterangepicker</h4>
									<p>Bootstrap daterangepicker provides a component for choosing date ranges, dates and times. Please read the <a href="http://www.daterangepicker.com/" target="_blank">official documentation</a> for the full list of options.</p>
									<div class="card">
										<div class="card-body pb-2">
											<form>
												<div class="row">
													<div class="col-xl-6">
														<div class="mb-3">
															<label class="form-label">Default Date Ranges</label>
															<div class="input-group" id="default-daterange">
																<input type="text" name="default-daterange" class="form-control" value="" placeholder="click to select the date range">
																<label class="input-group-text"><i class="fa fa-calendar"></i></label>
															</div>
														</div>
													</div>
													<div class="col-xl-6">
														<div class="mb-3">
															<label class="form-label">Advance Date Ranges</label>
															<div id="advance-daterange" class="btn btn-default d-flex align-items-center text-start">
																<span class="text-truncate">&nbsp;</span>
																<i class="fa fa-caret-down ms-auto"></i>
															</div>
														</div>
													</div>
												</div>
											</form>
										</div>
										<div class="hljs-container rounded-bottom">
											<pre><code class="xml" data-url="assets/data/form-plugins/code-2.json"></code></pre>
										</div>
									</div>
								</div>
								<!-- END #bootstrapDaterangepicker -->
								
								<!-- BEGIN #bootstrapTimepicker -->
								<div id="bootstrapTimepicker" class="mb-5">
									<h4>Bootstrap timepicker</h4>
									<p>Bootstrap timepicker provide an easy way to select a time for a text input using your mouse or keyboards arrow keys. Please read the <a href="https://jdewit.github.io/bootstrap-timepicker/" target="_blank">official documentation</a> for the full list of options.</p>
									<div class="card">
										<div class="card-body pb-2">
											<form>
												<div class="row">
													<div class="col-xl-6">
														<div class="mb-3">
															<label class="form-label">Default <span class="text-danger">*</span></label>
															<div class="input-group bootstrap-timepicker timepicker">
																<input id="timepicker-default" type="text" class="form-control">
																<span class="input-group-addon input-group-text">
																	<i class="fa fa-clock"></i>
																</span>
															</div>
														</div>
													</div>
													<div class="col-xl-6">
														<div class="mb-3">
															<label class="form-label">24hr mode and seconds enabled <span class="text-danger">*</span></label>
															<div class="bootstrap-timepicker timepicker">
																<input id="timepicker-seconds" type="text" class="form-control" value="1:00:00">
															</div>
														</div>
													</div>
													<div class="col-xl-6">
														<div class="mb-3">
															<label class="form-label">Minute Step 5 <span class="text-danger">*</span></label>
															<div class="bootstrap-timepicker timepicker">
																<input type="text" data-provide="timepicker" data-minute-step="5" data-template="false" class="form-control" value="7:00:00" data-show-meridian="false" data-show-seconds="true">
															</div>
														</div>
													</div>
												</div>
											</form>
										</div>
										<div class="hljs-container rounded-bottom">
											<pre><code class="xml" data-url="assets/data/form-plugins/code-3.json"></code></pre>
										</div>
									</div>
								</div>
								<!-- END #bootstrapTimepicker -->
								
								<!-- BEGIN #bootstrapSlider -->
								<div id="bootstrapSlider" class="mb-5">
									<h4>Bootstrap slider</h4>
									<p>Bootstrap slider provides single handle that can be moved with the mouse or by using the arrow keys. Please read the <a href="https://seiyria.com/bootstrap-slider/" target="_blank">official documentation</a> for the full list of options.</p>
									<div class="card">
										<div class="card-body pb-2">
											<form>
												<div class="row">
													<div class="col-md-9">
														<div class="mb-3">
															<label class="form-label">Default <span class="text-danger">*</span></label>
															<div>
																<input id="slider-default" class="form-control" type="text" data-slider-min="0" data-slider-max="20" data-slider-step="1" data-slider-value="14">
															</div>
														</div>
														<div class="mb-3">
															<label class="form-label">Range <span class="text-danger">*</span></label>
															<div>
																<div class="clearfix">
																	<b class="pull-right">€ 1000</b>
																	<b>€ 10</b>
																</div>
																<input id="slider-range" class="form-control" type="text" value="" data-slider-min="10" data-slider-max="1000" data-slider-step="5" data-slider-value="[250,450]">
															</div>
														</div>
														<div class="mb-3">
															<label class="form-label">Tooltip (always show) <span class="text-danger">*</span></label>
															<div>
																<input id="slider-tooltip" class="form-control" data-slider-id="ex1Slider" type="text" data-slider-min="0" data-slider-max="20" data-slider-step="1" data-slider-value="14">
															</div>
														</div>
														<div class="form-group m-b-5">
															<label class="form-label">Disabled <span class="text-danger">*</span></label>
															<div>
																<input id="slider-disabled" class="form-control" type="text" data-slider-min="0" data-slider-max="20" data-slider-step="1" data-slider-value="5" data-slider-enabled="false">
															</div>
														</div>
													</div>
													<div class="col-md-3">
														<div class="mb-3">
															<label>Vertical <span class="text-danger">*</span></label>
															<div>
																<input id="slider-vertical" class="form-control" type="text" data-slider-min="-5" data-slider-max="20" data-slider-step="1" data-slider-value="-3" data-slider-orientation="vertical">
															</div>
														</div>
													</div>
												</div>
											</form>
										</div>
										<div class="hljs-container rounded-bottom">
											<pre><code class="xml" data-url="assets/data/form-plugins/code-4.json"></code></pre>
										</div>
									</div>
								</div>
								<!-- END #bootstrapSlider -->
								
								<!-- BEGIN #jqueryTypeahead -->
								<div id="jQueryTypeahead" class="mb-5">
									<h4>jQuery typeahead</h4>
									<p>The jQuery Typeahead Search is a simple plugin that suggest search results from the character(s) that were typed in the search bar using JavaScript. Please read the <a href="http://www.runningcoder.org/jquerytypeahead/documentation/" target="_blank">official documentation</a> for the full list of options.</p>
									<div class="card">
										<div class="card-body">
											<form>
												<div class="row">
													<div class="col-xl-8">
														<div class="typeahead__container mb-1">
															<label class="form-label">Default <span class="text-danger">*</span></label>
															<div class="typeahead__field">
																<div class="typeahead__query input-group">
																	<span class="input-group-text"><i class="fa fa-search"></i></span>
																	<input class="form-control" name="country_v1[query]" id="typeahead" placeholder="Type 'af'" autocomplete="off">
																</div>
															</div>
														</div>
													</div>
												</div>
											</form>
										</div>
										<div class="hljs-container rounded-bottom">
											<pre><code class="xml" data-url="assets/data/form-plugins/code-5.json"></code></pre>
										</div>
									</div>
								</div>
								<!-- END #jqueryTypeahead -->
								
								<!-- BEGIN #jQueryTagIt -->
								<div id="jQueryTagIt" class="mb-5">
									<h4>jQuery Tag It</h4>
									<p>jQuery Tag It is a jQuery plugin providing a Simple and configurable tag editing widget with autocomplete support. Please read the <a href="http://aehlke.github.io/tag-it/" target="_blank">official documentation</a> for the full list of options.</p>
									<div class="card">
										<div class="card-body">
											<form>
												<div class="mb-2">
													<label class="form-label">Default <span class="text-danger">*</span></label>
													<ul id="jquery-tagit" class="tagit form-control">
														<li>fancy</li>
														<li>new</li>
														<li>tag</li>
														<li>demo</li>
													</ul>
												</div>
												<p class="form-text mb-0">
													You may enter the text (c++, java, php, javascript, ruby, python) for autocomplete preview
												</p>
											</form>
										</div>
										<div class="hljs-container rounded-bottom">
											<pre><code class="xml" data-url="assets/data/form-plugins/code-6.json"></code></pre>
										</div>
									</div>
								</div>
								<!-- END #jQueryTagIt -->
								
								<!-- BEGIN #jQueryMarksedInput -->
								<div id="jQueryMarksedInput" class="mb-5">
									<h4>jQuery masked input</h4>
									<p>jQuery masked input allows a user to more easily enter fixed width input where you would like them to enter the data in a certain format. Please read the <a href="https://github.com/excellalabs/jquery.maskedinput#readme" target="_blank">official documentation</a> for the full list of options.</p>
									<div class="card">
										<div class="card-body pb-2">
											<form>
												<div class="row">
													<div class="col-xl-6">
														<div class="mb-3">
															<label class="form-label">Date <span class="text-danger">*</span></label>
															<input type="text" id="masked-input-date" class="form-control" placeholder="mm/dd/yyyy">
														</div>
													</div>
													<div class="col-xl-6">
														<div class="mb-3">
															<label class="form-label">Phone <span class="text-danger">*</span></label>
															<input type="text" id="masked-input-phone" class="form-control" placeholder="(999) 999-9999">
														</div>
													</div>
												</div>
											</form>
										</div>
										<div class="hljs-container rounded-bottom">
											<pre><code class="xml" data-url="assets/data/form-plugins/code-7.json"></code></pre>
										</div>
									</div>
								</div>
								<!-- END #jQueryMarksedInput -->
								
								<!-- BEGIN #jQueryFileUpload -->
								<div id="jQueryFileUpload" class="mb-5">
									<h4>jQuery file upload</h4>
									<p>File Upload widget with multiple file selection, drag&drop support, progress bars, validation and preview images, audio and video for jQuery. Please read the <a href="https://blueimp.github.io/jQuery-File-Upload/" target="_blank">official documentation</a> for the full list of options.</p>
									<form id="fileupload" action="//jquery-file-upload.appspot.com/" name="file_upload_form" method="POST" enctype="multipart/form-data">
										<div class="card">
											<div class="card-body pb-2">
												<div class="fileupload-buttonbar mb-2">
													<div class="d-block d-lg-flex align-items-center">
														<span class="btn btn-primary fileinput-button fs-13px fw-semibold me-2 mb-1">
															<i class="fa fa-fw fa-plus"></i>
															<span>Add files...</span>
															<input type="file" name="files[]" multiple="">
														</span>
														<button type="submit" class="btn btn-default fs-13px fw-semibold me-2 mb-1 start">
															<i class="fa fa-fw fa-upload"></i>
															<span>Start upload</span>
														</button>
														<button type="reset" class="btn btn-default fs-13px fw-semibold me-2 mb-1 cancel">
															<i class="fa fa-fw fa-ban"></i>
															<span>Cancel upload</span>
														</button>
														<button type="button" class="btn btn-default fs-13px fw-semibold me-2 mb-1 delete">
															<i class="fa fa-fw fa-trash"></i>
															<span>Delete</span>
														</button>
														<div class="form-check ms-2 mb-1">
															<input type="checkbox" id="toggle-delete" class="form-check-input toggle">
															<label for="toggle-delete" class="form-check-label">Select Files</label>
														</div>
													</div>
												</div>
												<div id="error-msg"></div>
											</div>
											<table class="table table-card mb-0 fs-13px">
												<thead>
													<tr class="fs-12px">
														<th class="pt-2 pb-2 w-25">Preview</th>
														<th class="pt-2 pb-2 w-25">Filename</th>
														<th class="pt-2 pb-2 w-25">Size</th>
														<th class="pt-2 pb-2 w-25">Action</th>
													</tr>
												</thead>
												<tbody class="files">
													<tr class="empty-row">
														<td colspan="4" class="text-center p-3">
															<div class="text-body text-opacity-25 my-3"><i class="fa fa-file-archive fa-3x"></i></div> 
															No file uploaded
														</td>
													</tr>
												</tbody>
											</table>
											<div class="hljs-container rounded-bottom">
											<pre><code class="xml" data-url="assets/data/form-plugins/code-8.json"></code></pre>
											</div>
										</div>
									</form>
								</div>
								<!-- END #jQueryFileUpload -->
								
								<!-- BEGIN #summernote -->
								<div id="summernote" class="mb-5">
									<h4>Summernote</h4>
									<p>Summernote is a super simple WYSIWYG Editor on Bootstrap. It allows you to edit the HTML tag and preview it. Please read the <a href="https://summernote.org/" target="_blank">official documentation</a> for the full list of options.</p>
									
									<div class="card" style="z-index: 1020;">
										<form>
											<textarea name="text" class="summernote" id="contents" title="Contents">
<div class="clearfix pt-3 pb-3">
  <img src="assets/img/gallery/gallery-1.jpg" alt="" width="283" class="rounded float-start me-3 mb-3">
  <div>
    <h3 class="mt-0">Summernote</h3>
    <p class="mb-0">
    	Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed eu sollicitudin est. Cras et feugiat magna. Fusce sit amet euismod sem, pellentesque pellentesque risus. Quisque id lobortis quam. Nulla non magna vel ipsum volutpat malesuada dapibus sit amet elit. Quisque iaculis placerat lorem vel vestibulum. Maecenas nisi lacus, finibus vel massa vitae, hendrerit aliquet urna.
    	Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Aliquam egestas commodo varius. Aliquam enim ante, pharetra eu augue sed, dignissim semper mauris. Mauris fringilla arcu libero. Proin maximus enim quis diam condimentum, vel feugiat sapien sodales. Aliquam erat volutpat. Sed lorem nunc, commodo molestie ante ac, varius elementum neque. Nunc sem erat, varius vel sapien a, ultrices condimentum dolor. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.
    </p>
  </div>
</div>
<hr>
<div class="clearfix pt-3 pb-3">
  <img src="assets/img/gallery/gallery-2.jpg" alt="" width="283" class="rounded float-end ms-3 mb-3">
  <div>
    <h2 class="mt-0">Easy to Install</h2>
    <p class="mb-0">
      Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed eu sollicitudin est. Cras et feugiat magna. Fusce sit amet euismod sem, pellentesque pellentesque risus. Quisque id lobortis quam. Nulla non magna vel ipsum volutpat malesuada dapibus sit amet elit. Quisque iaculis placerat lorem vel vestibulum. Maecenas nisi lacus, finibus vel massa vitae, hendrerit aliquet urna.
      Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Aliquam egestas commodo varius. Aliquam enim ante, pharetra eu augue sed, dignissim semper mauris. Mauris fringilla arcu libero. Proin maximus enim quis diam condimentum, vel feugiat sapien sodales. Aliquam erat volutpat. Sed lorem nunc, commodo molestie ante ac, varius elementum neque. Nunc sem erat, varius vel sapien a, ultrices condimentum dolor. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.
    </p>
  </div>
</div>
											</textarea>
										</form>
										<div class="hljs-container rounded-bottom">
											<pre><code class="xml" data-url="assets/data/form-plugins/code-9.json"></code></pre>
										</div>
									</div>
								</div>
								<!-- END #summernote -->
								
								<!-- BEGIN #selectPicker -->
								<div id="selectPicker" class="mb-5">
									<h4>Select picker</h4>
									<p>Select picker is jQuery plugin for multiselect tag-like picker. Please read the <a href="https://picker.uhlir.dev/" target="_blank">official documentation</a> for the full list of options.</p>
									<div class="card">
										<div class="card-body pb-2">
											<form>
												<div class="row">
													<div class="col-xl-6">
														<div class="mb-3">
															<label class="form-label">Default <span class="text-danger">*</span></label>
															<select class="form-control" id="ex-basic">
																<option>Mustard</option>
																<option>Ketchup</option>
																<option>Relish</option>
															</select>
														</div>
													</div>
													<div class="col-xl-6">
														<div class="mb-3">
															<label class="form-label">Multiple SelectBox <span class="text-danger">*</span></label>
															<select class="selectpicker form-control" id="ex-multiselect" multiple="">
																<optgroup label="Picnic">
																	<option>Mustard</option>
																	<option>Ketchup</option>
																	<option>Relish</option>
																</optgroup>
																<optgroup label="Camping">
																	<option>Tent</option>
																	<option>Flashlight</option>
																	<option>Toilet Paper</option>
																</optgroup>
															</select>
														</div>
													</div>
													<div class="col-xl-6">
														<div class="mb-3">
															<label class="form-label">Live Search <span class="text-danger">*</span></label>
															<select class="selectpicker form-control" id="ex-search" multiple="">
																<option value="1">Mustard</option>
																<option value="2">Ketchup</option>
																<option value="3">Relish</option>
																<option value="4">Tent</option>
																<option value="5">Flashlight</option>
																<option value="6">Toilet Paper</option>
															</select>
														</div>
													</div>
												</div>
											</form>
										</div>
										<div class="hljs-container rounded-bottom">
											<pre><code class="xml" data-url="assets/data/form-plugins/code-10.json"></code></pre>
										</div>
									</div>
								</div>
								<!-- END #bootstrapSelect -->
								
								<!-- BEGIN #spectrumColorpicker -->
								<div id="spectrumColorpicker" class="mb-5">
									<h4>Spectrum colorpicker</h4>
									<p>Spectrum is a jQuery plugin for colorpicker. Please read the <a href="https://seballot.github.io/spectrum/" target="_blank">official documentation</a> for the full list of options.</p>
									<div class="card">
										<div class="card-body pb-2">
											<form>
												<div class="row">
													<div class="col-xl-6">
														<div class="mb-3">
															<label class="form-label">Default <span class="text-danger">*</span></label>
															<input type="text" value="#007aff" class="form-control" id="colorpicker-default">
														</div>
													</div>
												</div>
											</form>
										</div>
										<div class="hljs-container rounded-bottom">
											<pre><code class="xml" data-url="assets/data/form-plugins/code-11.json"></code></pre>
										</div>
									</div>
								</div>
								<!-- END #spectrumColorpicker -->
							</div>
							<!-- END col-9-->
							<!-- BEGIN col-3 -->
							<div class="col-xl-3">
								<!-- BEGIN #sidebar-bootstrap -->
								<nav id="sidebar-bootstrap" class="navbar navbar-sticky d-none d-xl-block">
									<nav class="nav text-nowrap">
										<a class="nav-link" href="#bootstrapDatepicker" data-toggle="scroll-to">Bootstrap datepicker</a>
										<a class="nav-link text-nowrap" href="#bootstrapDaterangepicker" data-toggle="scroll-to">Bootstrap daterangepicker</a>
										<a class="nav-link" href="#bootstrapTimepicker" data-toggle="scroll-to">Bootstrap timepicker</a>
										<a class="nav-link" href="#bootstrapSlider" data-toggle="scroll-to">Bootstrap slider</a>
										<a class="nav-link" href="#jQueryTypeahead" data-toggle="scroll-to">jQuery Typeahead</a>
										<a class="nav-link" href="#jQueryTagIt" data-toggle="scroll-to">jQuery Tag-it</a>
										<a class="nav-link" href="#jQueryMarksedInput" data-toggle="scroll-to">jQuery masked input</a>
										<a class="nav-link" href="#jQueryFileUpload" data-toggle="scroll-to">jQuery file upload</a>
										<a class="nav-link" href="#summernote" data-toggle="scroll-to">Summernote</a>
										<a class="nav-link" href="#selectPicker" data-toggle="scroll-to">Select picker</a>
										<a class="nav-link" href="#spectrumColorpicker" data-toggle="scroll-to">Spectrum colorpicker</a>
									</nav>
								</nav>
								<!-- END #sidebar-bootstrap -->
							</div>
							<!-- END col-3 -->
						</div>
						<!-- END row -->
					</div>
					<!-- END col-10 -->
				</div>
				<!-- END row -->
			</div>
			<!-- END container -->
		</div>
		<!-- END #content -->
		
		<!-- BEGIN theme-panel -->
		<div class="app-theme-panel">
			<div class="app-theme-panel-container">
				<a href="javascript:;" data-toggle="theme-panel-expand" class="app-theme-toggle-btn"><i class="bi bi-sliders"></i></a>
				<div class="app-theme-panel-content">
					<div class="fw-bold text-body mb-2">
						Theme Color
					</div>
					<div class="app-theme-list">
						<div class="app-theme-list-item"><a href="javascript:;" class="app-theme-list-link bg-pink" data-theme-class="theme-pink" data-toggle="theme-selector" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-container="body" data-bs-title="Pink"></a></div>
						<div class="app-theme-list-item"><a href="javascript:;" class="app-theme-list-link bg-red" data-theme-class="theme-red" data-toggle="theme-selector" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-container="body" data-bs-title="Red"></a></div>
						<div class="app-theme-list-item"><a href="javascript:;" class="app-theme-list-link bg-warning" data-theme-class="theme-warning" data-toggle="theme-selector" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-container="body" data-bs-title="Orange"></a></div>
						<div class="app-theme-list-item"><a href="javascript:;" class="app-theme-list-link bg-yellow" data-theme-class="theme-yellow" data-toggle="theme-selector" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-container="body" data-bs-title="Yellow"></a></div>
						<div class="app-theme-list-item"><a href="javascript:;" class="app-theme-list-link bg-lime" data-theme-class="theme-lime" data-toggle="theme-selector" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-container="body" data-bs-title="Lime"></a></div>
						<div class="app-theme-list-item"><a href="javascript:;" class="app-theme-list-link bg-green" data-theme-class="theme-green" data-toggle="theme-selector" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-container="body" data-bs-title="Green"></a></div>
						<div class="app-theme-list-item"><a href="javascript:;" class="app-theme-list-link bg-teal" data-theme-class="theme-teal" data-toggle="theme-selector" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-container="body" data-bs-title="Teal"></a></div>
						<div class="app-theme-list-item"><a href="javascript:;" class="app-theme-list-link bg-info" data-theme-class="theme-info" data-toggle="theme-selector" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-container="body" data-bs-title="Cyan"></a></div>
						<div class="app-theme-list-item active"><a href="javascript:;" class="app-theme-list-link bg-primary" data-theme-class="" data-toggle="theme-selector" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-container="body" data-bs-title="Default"></a></div>
						<div class="app-theme-list-item"><a href="javascript:;" class="app-theme-list-link bg-purple" data-theme-class="theme-purple" data-toggle="theme-selector" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-container="body" data-bs-title="Purple"></a></div>
						<div class="app-theme-list-item"><a href="javascript:;" class="app-theme-list-link bg-indigo" data-theme-class="theme-indigo" data-toggle="theme-selector" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-container="body" data-bs-title="Indigo"></a></div>
						<div class="app-theme-list-item"><a href="javascript:;" class="app-theme-list-link bg-gray-200" data-theme-class="theme-gray-500" data-toggle="theme-selector" data-bs-toggle="tooltip" data-bs-trigger="hover" data-bs-container="body" data-bs-title="Gray"></a></div>
					</div>
					<hr class="opacity-1">
					<div class="row mt-10px">
						<div class="col-8">
							<div class="fw-bold text-body d-flex mb-1 align-items-center">
								Dark Mode 
								<i class="bi bi-moon-fill ms-2 my-n1 fs-5 text-body text-opacity-25"></i>
							</div>
							<div class="lh-sm">
								<small class="text-body opacity-50">Adjust the appearance to reduce glare and give your eyes a break.</small>
							</div>
						</div>
						<div class="col-4 d-flex">
							<div class="form-check form-switch ms-auto mb-0">
								<input type="checkbox" class="form-check-input" name="app-theme-dark-mode" data-toggle="theme-dark-mode" id="appThemeDarkMode" value="1">
								<label class="form-check-label" for="appThemeDarkMode"></label>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
		<!-- END theme-panel -->
		<!-- BEGIN btn-scroll-top -->
		<a href="#" data-toggle="scroll-to-top" class="btn-scroll-top fade"><i class="fa fa-arrow-up"></i></a>
		<!-- END btn-scroll-top -->
	</div>
	<!-- END #app -->
	
	<!-- BEGIN template-upload -->
	<script data-cfasync="false" src="../cdn-cgi/scripts/5c5dd728/cloudflare-static/email-decode.min.js"></script><script id="template-upload" type="text/x-tmpl">
	{% for (var i=0, file; file=o.files[i]; i++) { %}
		<tr class="template-upload">
			<td>
				<span class="preview d-flex justify-content-center flex-align-center" style="height: 80px"></span>
			</td>
			<td>
				<p class="name mb-1">{%=file.name%}</p>
				<strong class="error text-danger"></strong>
			</td>
			<td>
				<p class="size mb-2">Processing...</p>
				<div class="progress progress-sm mb-0 h-10px progress-striped active"><div class="progress-bar bg-theme" style="min-width: 2em; width:0%;"></div></div>
			</td>
			<td nowrap>
				{% if (!i && !o.options.autoUpload) { %}
					<button class="btn btn-primary btn-sm d-block w-100 start" disabled>
						<span>Start</span>
					</button>
				{% } %}
				{% if (!i) { %}
					<button class="btn btn-outline-default btn-sm d-block w-100 cancel mt-2">
						<span>Cancel</span>
					</button>
				{% } %}
			</td>
		</tr>
	{% } %}
	</script>
	<!-- END template-upload -->
	
	<!-- BEGIN template-download -->
	<script id="template-download" type="text/x-tmpl">
	{% for (var i=0, file; file=o.files[i]; i++) { %}
		<tr class="template-download">
			<td>
				<span class="preview d-flex justify-content-center flex-align-center" style="height: 80px">
					{% if (file.thumbnailUrl) { %}
						<a href="{%=file.url%}" title="{%=file.name%}" download="{%=file.name%}" data-gallery><img src="{%=file.thumbnailUrl%}"></a>
					{% } %}
				</span>
			</td>
			<td>
				<p class="name">
					{% if (file.url) { %}
						<a href="{%=file.url%}" title="{%=file.name%}" download="{%=file.name%}" {%=file.thumbnailUrl?'data-gallery':''%}>{%=file.name%}</a>
					{% } else { %}
						<span>{%=file.name%}</span>
					{% } %}
				</p>
				{% if (file.error) { %}
					<div><span class="label label-danger">Error</span> {%=file.error%}</div>
				{% } %}
			</td>
			<td>
				<span class="size">{%=o.formatFileSize(file.size)%}</span>
			</td>
			<td nowrap>
				{% if (file.deleteUrl) { %}
					<button class="btn btn-outline-danger btn-sm btn-block delete" data-type="{%=file.deleteType%}" data-url="{%=file.deleteUrl%}"{% if (file.deleteWithCredentials) { %} data-xhr-fields='{"withCredentials":true}'{% } %}>
						<span>Delete</span>
					</button>
					<div class="form-check mt-2">
						<input type="checkbox" id="{%=file.deleteUrl%}" name="delete" value="1" class="form-check-input toggle">
						<label for="{%=file.deleteUrl%}" class="form-check-label"></label>
					</div>
				{% } else { %}
					<button class="btn btn-outline-default btn-sm d-block w-100 cancel">
						<span>Cancel</span>
					</button>
				{% } %}
			</td>
		</tr>
	{% } %}
	</script>
	<!-- END template-download -->
	
	<!-- ================== BEGIN core-js ================== -->
	<script src="assets/js/vendor.min.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/js/app.min.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<!-- ================== END core-js ================== -->
	
	<!-- ================== BEGIN page-js ================== -->
	<script src="assets/plugins/jquery-migrate/dist/jquery-migrate.min.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/plugins/bootstrap-datepicker/dist/js/bootstrap-datepicker.min.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/plugins/moment/min/moment.min.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/plugins/bootstrap-daterangepicker/daterangepicker.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/plugins/bootstrap-timepicker/js/bootstrap-timepicker.min.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/plugins/bootstrap-slider/dist/bootstrap-slider.min.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/plugins/jquery-typeahead/dist/jquery.typeahead.min.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/plugins/jquery.maskedinput/src/jquery.maskedinput.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/plugins/tag-it/js/tag-it.min.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/plugins/blueimp-file-upload/js/vendor/jquery.ui.widget.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/plugins/blueimp-tmpl/js/tmpl.min.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/plugins/blueimp-load-image/js/load-image.all.min.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/plugins/blueimp-canvas-to-blob/js/canvas-to-blob.min.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/plugins/blueimp-gallery/js/jquery.blueimp-gallery.min.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/plugins/blueimp-file-upload/js/jquery.iframe-transport.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/plugins/blueimp-file-upload/js/jquery.fileupload.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/plugins/blueimp-file-upload/js/jquery.fileupload-process.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/plugins/blueimp-file-upload/js/jquery.fileupload-image.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/plugins/blueimp-file-upload/js/jquery.fileupload-audio.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/plugins/blueimp-file-upload/js/jquery.fileupload-video.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/plugins/blueimp-file-upload/js/jquery.fileupload-validate.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/plugins/blueimp-file-upload/js/jquery.fileupload-ui.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/plugins/summernote/dist/summernote-lite.min.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/plugins/spectrum-colorpicker2/dist/spectrum.min.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/plugins/select-picker/dist/picker.min.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/plugins/%40highlightjs/cdn-assets/highlight.min.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/js/demo/highlightjs.demo.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/js/demo/form-plugins.demo.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script src="assets/js/demo/sidebar-scrollspy.demo.js" type="09655d7987d7ee003820155a-text/javascript"></script>
	<!-- ================== END page-js ================== -->
	
	
	<script async="" src="../gtag/js?id=G-Y3Q0VGQKY3" type="09655d7987d7ee003820155a-text/javascript"></script>
	<script type="09655d7987d7ee003820155a-text/javascript">
		window.dataLayer = window.dataLayer || [];
		function gtag(){dataLayer.push(arguments);}
		gtag('js', new Date());
	
		gtag('config', 'G-Y3Q0VGQKY3');
	</script>
<script src="../cdn-cgi/scripts/7d0fa10a/cloudflare-static/rocket-loader.min.js" data-cf-settings="09655d7987d7ee003820155a-|49" defer=""></script></body>
</html>
