<?php $__env->startSection('title', $settings->site_title); ?>


<?php $content = app('App\Http\Controllers\FrontController'); ?>
<?php $__env->startSection('content'); ?>


    <!-- Page Content -->
    <main class="flex-grow">
        <div class="animate-fade-in">
            <!-- Additional CSS for map and animations -->
<link href="https://cdn.jsdelivr.net/npm/leaflet@1.9.4/dist/leaflet.min.css" rel="stylesheet"/>
<script src="https://cdn.jsdelivr.net/npm/leaflet@1.9.4/dist/leaflet.min.js"></script>

<style>
    .tracking-status-dot {
        height: 12px;
        width: 12px;
        border-radius: 50%;
        display: inline-block;
    }

    .status-timeline-item::before {
        content: "";
        position: absolute;
        left: 6px;
        top: 24px;
        bottom: -12px;
        width: 2px;
        background-color: #e5e7eb;
        z-index: 0;
    }

    .status-timeline-item:last-child::before {
        display: none;
    }

    .pulse {
        animation: pulse 2s infinite;
    }

    @keyframes  pulse {
        0% {
            box-shadow: 0 0 0 0 rgba(252, 181, 41, 0.7);
        }
        70% {
            box-shadow: 0 0 0 10px rgba(252, 181, 41, 0);
        }
        100% {
            box-shadow: 0 0 0 0 rgba(252, 181, 41, 0);
        }
    }

    .leaflet-container {
        border-radius: 0.5rem;
        z-index: 10;
    }

    /* Print Styles */
    @media  print {
        @page  {
            size: A4;
            margin: 0.5cm;
        }

        body {
            background: white !important;
            color: #333 !important;
            font-size: 12pt;
        }

        header, footer, .no-print, button, .leaflet-container {
            display: none !important;
        }

        .print-receipt {
            display: block !important;
            background: white;
            padding: 20px;
            margin: 0 auto;
            max-width: 100%;
            box-shadow: none;
        }
    }
</style>

<!-- Navigation Controls -->
<section class="py-8 bg-gradient-to-br from-horizon-50 to-gold-50">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center">
            <a href="<?php echo e(route('track.form')); ?>" class="inline-flex items-center text-horizon-600 hover:text-horizon-800 transition-colors duration-200">
                <i class="fas fa-arrow-left mr-2"></i>
                Back to Tracking
            </a>

            <div class="flex space-x-3">
                <div x-data="{ shareOpen: false }" class="relative">
                    <button @click="shareOpen = !shareOpen" type="button" class="inline-flex items-center px-4 py-2 bg-white border border-gray-300 rounded-lg text-horizon-600 hover:text-horizon-800 hover:bg-gray-50 transition-colors duration-200">
                        <i class="fas fa-share-alt mr-2"></i>
                        <span class="hidden sm:inline">Share</span>
                    </button>

                    <div x-show="shareOpen" @click.away="shareOpen = false" class="absolute right-0 mt-2 w-60 bg-white rounded-lg shadow-lg p-4 z-50 text-sm animate-fade-in">
                        <div class="text-horizon-800 font-medium mb-3">Share tracking information</div>
                        <div class="flex space-x-3 mb-3">
                            <a href="mailto:?subject=Track Shipment  <?php echo e($courier->tracking_code); ?> &body=Track your shipment at: <?php echo e(route('track.form')); ?>" class="text-gray-600 hover:text-horizon-600">
                                <i class="fas fa-envelope text-xl"></i>
                            </a>
                            <a href="#" target="_blank" class="text-gray-600 hover:text-green-600">
                                <i class="fab fa-whatsapp text-xl"></i>
                            </a>
                            <a href="#" target="_blank" class="text-gray-600 hover:text-blue-400">
                                <i class="fab fa-twitter text-xl"></i>
                            </a>
                            <a href="#" onclick="copyTrackingLink(); return false;" class="text-gray-600 hover:text-gold-600">
                                <i class="fas fa-copy text-xl"></i>
                            </a>
                        </div>
                        <div class="flex items-center border rounded overflow-hidden">
                            <input type="text" readonly value="<?php echo e(route('track.form')); ?>" id="tracking-url" class="w-full px-2 py-1 text-xs outline-none">
                            <button onclick="copyTrackingLink()" class="bg-gold-50 px-2 py-1 text-gold-600 text-xs hover:bg-gold-100">Copy</button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Shipment Header -->
<section class="py-8">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="bg-gradient-to-r from-horizon-700 to-horizon-800 rounded-2xl p-8 md:p-12 text-white relative overflow-hidden shadow-2xl">
            <div class="absolute right-0 top-0 opacity-10">
                <i class="fas fa-truck text-9xl transform -rotate-12 translate-x-10 -translate-y-10"></i>
            </div>

            <div class="relative z-10">
                <div class="flex flex-col md:flex-row justify-between gap-4 items-stretch mb-8">
    <!-- Tracking Code + Status -->
    <div class="flex-1 bg-white/10 backdrop-blur-sm px-6 py-4 rounded-lg">
        <h1 class="font-display text-3xl md:text-4xl font-bold flex items-center mb-2">
            <i class="fas fa-box mr-3"></i>
            <?php echo e($courier->tracking_code); ?>

        </h1>
        <p class="text-gray-200 text-lg">
            Status:
            <span class="font-semibold text-gold-400"><?php echo e($courier->status); ?></span>
        </p>
    </div>

    <!-- Print Shipping Invoice -->
    <div class="flex-1 bg-white/10 backdrop-blur-sm px-6 py-4 rounded-lg flex items-center justify-center text-center">
        <a href="<?php echo e(route('printnow', $courier->id)); ?>"
           class="text-2xl font-bold text-gold-400 hover:underline">
           <i class="fas fa-print mr-2"></i> Print Shipping Invoice
        </a>
    </div>

    <!-- Estimated Delivery -->
    <div class="flex-1 bg-white/10 backdrop-blur-sm px-6 py-4 rounded-lg">
        <p class="text-sm text-gray-200">Estimated Delivery</p>
        <p class="text-2xl font-bold text-gold-400">
            <?php echo e(\Carbon\Carbon::parse($courier->estimated_delivery)->toDayDateTimeString()); ?>

        </p>
    </div>
</div>


                <!-- Progress Bar -->
                <div class="mb-8">
                    <div class="flex justify-between items-center mb-3">
                        <span class="text-sm font-semibold px-3 py-1 bg-gold-500/20 text-gold-400 rounded-full">
                            Shipment Progress
                        </span>
                        <span class="text-lg font-bold text-gold-400"> <?php echo e($courier->shipment_progress); ?>%</span>
                    </div>
                    <div class="h-3 w-full bg-white/20 rounded-full overflow-hidden">
                        <div class="h-full bg-gradient-to-r from-gold-400 to-gold-500 transition-all duration-1000" style="width:  <?php echo e($courier->shipment_progress); ?>%"></div>
                    </div>
                </div>

                <!-- Quick Info Grid -->
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4">
                    <div class="bg-white/10 backdrop-blur-sm rounded-lg p-4">
                        <p class="text-xs text-gray-300 mb-1">Origin</p>
                        <p class="font-medium flex items-center">
                            <i class="fas fa-map-marker-alt mr-2 text-gold-400"></i>
                            <?php echo e($courier->origin); ?>

                        </p>
                    </div>
                    <div class="bg-white/10 backdrop-blur-sm rounded-lg p-4">
                        <p class="text-xs text-gray-300 mb-1">Current Location</p>
                        <p class="font-medium flex items-center">
                            <i class="fas fa-location-dot mr-2 text-gold-400 pulse"></i>
                            <?php echo e($courier->current_location ?? $courier->status); ?>

                        </p>
                    </div>
                    <div class="bg-white/10 backdrop-blur-sm rounded-lg p-4">
                        <p class="text-xs text-gray-300 mb-1">Destination</p>
                        <p class="font-medium flex items-center">
                            <i class="fas fa-flag-checkered mr-2 text-gold-400"></i>
                         <?php echo e($courier->destination); ?>

                        </p>
                    </div>
                    <div class="bg-white/10 backdrop-blur-sm rounded-lg p-4">
                        <p class="text-xs text-gray-300 mb-1">Total Freight Cost</p>
                        <p class="font-medium flex items-center">
                            <i class="fas fa-dollar-sign mr-2 text-gold-400"></i>
                            $<?php echo e($courier->freight_cost ?? '1200'); ?>

                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Permit Required Notification -->
<section class="py-4">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div x-data="{ showPermitModal: false }">
            <?php if( $courier->status === 'Customs'): ?>
            <!-- Notification Banner -->
            <div @click="showPermitModal = true" class="bg-amber-50 border-l-4 border-amber-500 p-6 rounded-lg shadow-soft flex items-center justify-between cursor-pointer hover:bg-amber-100 transition-colors duration-200">
                <div class="flex items-center">
                    <div class="bg-amber-500 rounded-full p-3 mr-4 flex-shrink-0">
                        <i class="fas fa-certificate text-white text-lg"></i>
                    </div>
                    <div>
                        <h3 class="font-semibold text-amber-800 text-lg">Customs Clearance Document Required</h3>
                        <p class="text-amber-700">This shipment requires a customs clearance document. Click for details.</p>
                    </div>
                </div>
                <div class="bg-amber-500 hover:bg-amber-600 text-white px-4 py-2 rounded-lg shadow transition-colors flex-shrink-0">
                    <span class="hidden sm:inline">Details</span>
                    <i class="fas fa-arrow-right ml-2"></i>
                </div>
            </div>
            <?php endif; ?>

            <!-- Modal Popup -->
            <div x-show="showPermitModal"
                 class="fixed inset-0 bg-black bg-opacity-50 z-50 flex items-center justify-center p-4"
                 x-transition:enter="transition ease-out duration-300"
                 x-transition:enter-start="opacity-0 transform scale-95"
                 x-transition:enter-end="opacity-100 transform scale-100"
                 x-transition:leave="transition ease-in duration-200"
                 x-transition:leave-start="opacity-100 transform scale-100"
                 x-transition:leave-end="opacity-0 transform scale-95"
                 style="display: none;">
                <div @click.outside="showPermitModal = false" class="bg-white rounded-xl shadow-2xl w-full max-w-md relative">
                    <!-- Modal content here -->
                    <div class="bg-gradient-to-r from-amber-500 to-amber-600 text-white p-6 rounded-t-xl">
                        <div class="flex justify-between items-center">
                            <h3 class="text-xl font-bold flex items-center">
                                <i class="fas fa-certificate mr-2"></i>
                                Customs Clearance Document
                            </h3>
                            <button @click="showPermitModal = false" class="text-white hover:text-gray-200 focus:outline-none">
                                <i class="fas fa-times"></i>
                            </button>
                        </div>
                    </div>
                    <div class="p-6">
                        <div class="bg-amber-50 border border-amber-200 rounded-lg p-4 mb-4">
                            <p class="text-amber-800">Your shipment requires a permit that must be purchased before delivery can be completed.</p>
                        </div>
                        <a href="mailto:<?php echo e($settings->contact_email); ?>?subject=Permit Request for Customs Clearance Document for <?php echo e($courier->tracking_code); ?>" class="flex items-center justify-center w-full bg-amber-500 hover:bg-amber-600 text-white font-medium py-3 px-4 rounded-lg transition-colors">
                            <i class="fas fa-envelope mr-2"></i>
                            Request Permit via Email
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Main Content Area -->
<section class="py-8">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Left Column -->
            <div class="lg:col-span-2 space-y-8">
                <!-- Map Section -->
                                <div class="bg-white rounded-xl shadow-soft overflow-hidden">
                    <div class="p-6 bg-horizon-50 border-b">
                        <h3 class="font-display text-xl font-bold text-horizon-800 flex items-center">
                            <i class="fas fa-map-location-dot mr-3 text-gold-600"></i>
                            Shipment Route
                        </h3>
                    </div>
                    <div id="map" class="w-full h-[400px]" style="min-height: 400px; z-index: 1;"></div>

<script>
document.addEventListener("DOMContentLoaded", async () => {
    const map = L.map("map").setView([0, 0], 2);

    L.tileLayer("https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png", {
        attribution: "&copy; OpenStreetMap contributors",
    }).addTo(map);

    // Custom icons with Heritage Crown colors
    const originIcon = L.divIcon({
        className: 'custom-div-icon',
        html: `<div style="background-color: #1a5a40; color: white; width: 30px; height: 30px; border-radius: 50%; display: flex; align-items: center; justify-content: center; box-shadow: 0 0 0 5px rgba(26, 90, 64, 0.2);"><i class="fas fa-warehouse" style="font-size: 14px;"></i></div>`,
        iconSize: [30, 30],
        iconAnchor: [15, 15]
    });

    const destinationIcon = L.divIcon({
        className: 'custom-div-icon',
        html: `<div style="background-color: #059669; color: white; width: 30px; height: 30px; border-radius: 50%; display: flex; align-items: center; justify-content: center; box-shadow: 0 0 0 5px rgba(5, 150, 105, 0.2);"><i class="fas fa-flag-checkered" style="font-size: 14px;"></i></div>`,
        iconSize: [30, 30],
        iconAnchor: [15, 15]
    });

    const currentLocationIcon = L.divIcon({
        className: 'custom-div-icon',
        html: `<div style="background-color: #fcb529; color: white; width: 30px; height: 30px; border-radius: 50%; display: flex; align-items: center; justify-content: center; box-shadow: 0 0 0 5px rgba(252, 181, 41, 0.2);"><i class="fas fa-truck" style="font-size: 14px;"></i></div>`,
        iconSize: [30, 30],
        iconAnchor: [15, 15]
    });

    const locations = [
        { name: "<?php echo e($courier->origin); ?>", label: "Origin", type: "origin", icon: originIcon },
        { name: "<?php echo e($courier->current_location); ?>", label: "Current Location", type: "current", icon: currentLocationIcon },
        { name: "<?php echo e($courier->destination); ?>", label: "Destination", type: "destination", icon: destinationIcon },
    ];

    const bounds = [];
    const routePoints = [];

    for (const loc of locations) {
        if (!loc.name) continue;

        try {
            const res = await fetch(`https://nominatim.openstreetmap.org/search?q=${encodeURIComponent(loc.name)}&format=json&limit=1`);
            const data = await res.json();

            if (data.length > 0) {
                const lat = parseFloat(data[0].lat);
                const lon = parseFloat(data[0].lon);
                const coords = [lat, lon];

                bounds.push(coords);
                routePoints.push(coords);

                L.marker(coords, { icon: loc.icon })
                    .addTo(map)
                    .bindPopup(`<strong>${loc.label}</strong><br>${loc.name}`);
            } else {
                console.warn("Could not geocode:", loc.name);
            }
        } catch (error) {
            console.error("Geocoding failed for:", loc.name, error);
        }
    }

    if (routePoints.length >= 2) {
        L.polyline(routePoints, {
            color: "#fcb529",
            weight: 4,
            opacity: 0.8,
        }).addTo(map);
    }

    if (bounds.length) {
        map.fitBounds(bounds, { padding: [40, 40] });
    } else {
        map.setView([20, 0], 2);
    }

    setTimeout(() => map.invalidateSize(), 300);
});
</script>


                </div>

                <!-- Interactive Timeline -->
                <div class="bg-white rounded-xl shadow-soft overflow-hidden" x-data="{ showAll: false }">
                    <div class="p-6 bg-horizon-50 border-b flex justify-between items-center">
                        <h3 class="font-display text-xl font-bold text-horizon-800 flex items-center">
                            <i class="fas fa-clock-rotate-left mr-3 text-gold-600"></i>
                            Shipment Timeline
                        </h3>
                                            </div>

                    <div class="p-8">
                        <div class="relative">
                            <!-- Timeline Line -->
                            <div class="absolute left-6 top-0 ml-px h-full w-0.5 bg-gray-200"></div>

                            <!-- Timeline Items -->
                            <div class="space-y-8">

                                <!-- Origin point -->
                                <div class="relative pl-12">
                                    <span class="absolute left-6 top-1 -ml-3 h-6 w-6 rounded-full border-2 border-horizon-600 bg-white flex items-center justify-center">
                                        <i class="fas fa-warehouse text-xs text-horizon-600"></i>
                                    </span>
                                    <div class="bg-horizon-50 rounded-lg p-4 border border-horizon-100">
                                        <div class="flex justify-between items-start">
                                            <h4 class="font-semibold text-horizon-800">Dispatched from Origin</h4>
                                            <span class="text-sm text-secondary-500"><?php echo e(\Carbon\Carbon::parse($courier->dispatch_date )->toDayDateTimeString()); ?></span>
                                        </div>
                                        <p class="text-secondary-600 mt-1"> <?php echo e($courier->origin); ?></p>
                                    </div>
                                </div>

                                <!-- Tracking updates -->
<!-- Tracking updates -->
<?php $__currentLoopData = $courier->updates; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $update): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<?php if($update->status == 'On Hold'): ?>
    <div class="relative pl-12">

            <span class="absolute left-6 top-1 -ml-3 h-6 w-6 rounded-full border-2 border-blue-500 bg-white flex items-center justify-center">
                <i class="fas fa-shipping-fast text-xs text-blue-500"></i>
            </span>
        <span class="absolute left-6 top-1 -ml-3 h-6 w-6 rounded-full border-2 border-yellow-400 bg-white flex items-center justify-center">
            <i class="fas fa-truck text-xs text-yellow-400"></i>
        </span>
        <div class="bg-yellow-50 rounded-lg p-4 border border-yellow-100">
            <div class="flex justify-between items-start">
                <h4 class="font-semibold text-horizon-800"><?php echo e($update->status); ?></h4>
                <span class="text-sm text-secondary-500">
                    <?php echo e(\Carbon\Carbon::parse($update->created_at)->toDayDateTimeString()); ?>

                </span>
            </div>
            <p class="text-secondary-600 mt-1"><?php echo e($update->location); ?></p>
        </div>
    </div>
    <?php elseif($update->status == 'Customs'): ?>
    <div class="relative pl-12">

            <span class="absolute left-6 top-1 -ml-3 h-6 w-6 rounded-full border-2 border-blue-500 bg-white flex items-center justify-center">
                <i class="fas fa-shipping-fast text-xs text-blue-500"></i>
            </span>
        <span class="absolute left-6 top-1 -ml-3 h-6 w-6 rounded-full border-2 border-yellow-400 bg-white flex items-center justify-center">
            <i class="fas fa-truck text-xs text-red-400"></i>
        </span>
        <div class="bg-red-200 rounded-lg p-4 border border-red-100">
            <div class="flex justify-between items-start">
                <h4 class="font-semibold text-horizon-800"><?php echo e($update->status); ?></h4>
                <span class="text-sm text-secondary-500">
                    <?php echo e(\Carbon\Carbon::parse($update->created_at)->toDayDateTimeString()); ?>

                </span>
            </div>
            <p class="text-secondary-600 mt-1"><?php echo e($update->location); ?></p>
            <?php if(!empty($update->comment)): ?>
                <div class="mt-2 text-sm text-horizon-800 bg-white rounded p-3 border border-yellow-200 shadow-sm">
                    <strong class="text-yellow-600">Comment:</strong>
                    <span><?php echo e($update->comment); ?></span>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <?php elseif($update->status == 'Delivered'): ?>
    <div class="relative pl-12">

            <span class="absolute left-6 top-1 -ml-3 h-6 w-6 rounded-full border-2 border-blue-500 bg-white flex items-center justify-center">
                <i class="fas fa-shipping-fast text-xs text-blue-500"></i>
            </span>
        <span class="absolute left-6 top-1 -ml-3 h-6 w-6 rounded-full border-2 border-gray-400 bg-white flex items-center justify-center">
            <i class="fas fa-truck text-xs text-horizon-400"></i>
        </span>
        <div class="bg-horizon-200 rounded-lg p-4 border border-green-100">
            <div class="flex justify-between items-start">
                <h4 class="font-semibold text-horizon-800"><?php echo e($update->status); ?></h4>
                <span class="text-sm text-secondary-500">
                    <?php echo e(\Carbon\Carbon::parse($update->created_at)->toDayDateTimeString()); ?>

                </span>
            </div>
            <p class="text-secondary-600 mt-1"><?php echo e($update->location); ?></p>
            <?php if(!empty($update->comment)): ?>
                <div class="mt-2 text-sm text-horizon-800 bg-white rounded p-3 border border-yellow-200 shadow-sm">
                    <strong class="text-yellow-600">Comment:</strong>
                    <span><?php echo e($update->comment); ?></span>
                </div>
            <?php endif; ?>
        </div>
    </div>


    <?php else: ?>
    <div class="relative pl-12">

            <span class="absolute left-6 top-1 -ml-3 h-6 w-6 rounded-full border-2 border-blue-500 bg-white flex items-center justify-center">
                <i class="fas fa-shipping-fast text-xs text-blue-500"></i>
            </span>
        <span class="absolute left-6 top-1 -ml-3 h-6 w-6 rounded-full  border-gray-300 bg-white flex items-center justify-center">
            <i class="fas fa-truck text-xs  text-horizon-600"></i>
        </span>
        <div class="bg-horizon-200 rounded-lg p-4 border border-green-100">
            <div class="flex justify-between items-start">
                <h4 class="font-semibold text-horizon-800"><?php echo e($update->status); ?></h4>
                <span class="text-sm text-secondary-500">
                    <?php echo e(\Carbon\Carbon::parse($update->created_at)->toDayDateTimeString()); ?>

                </span>
            </div>
            <p class="text-secondary-600 mt-1"><?php echo e($update->location); ?></p>
            <?php if(!empty($update->comment)): ?>
                <div class="mt-2 text-sm text-horizon-800 bg-white rounded p-3 border border-yellow-200 shadow-sm">
                    <strong class="text-yellow-600">Comment:</strong>
                    <span><?php echo e($update->comment); ?></span>
                </div>
            <?php endif; ?>
        </div>
    </div>
    <?php endif; ?>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<?php if($courier->status == 'Delivered'): ?>
                                <!-- Destination (projected) -->
                                <div class="relative pl-12">
                                    <span class="absolute left-6 top-1 -ml-3 h-6 w-6 rounded-full border-2

                                          border-gray-300 bg-white-500
                                                                             flex items-center justify-center">
                                                                                    <i class="fas fa-flag-checkered text-xs text-horizon-600"></i>
                                                                            </span>
                                    <div class=" bg-horizon-50  rounded-lg p-4">
                                        <div class="flex justify-between items-start">
                                            <h4 class="font-semibold text-horizon-800">Delivery at Destination</h4>
                                            <span class="text-sm text-secondary-500"><?php echo e(\Carbon\Carbon::parse($courier->estimated_delivery )->toDayDateTimeString()); ?>

</span>
                                        </div>
                                        <p class="text-secondary-600 mt-1"><?php echo e($courier->destination); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
<?php else: ?>
  <!-- Destination (projected) -->
                                <div class="relative pl-12">
                                    <span class="absolute left-6 top-1 -ml-3 h-6 w-6 rounded-full border-2

                                          border-gray-300 bg-white
                                                                             flex items-center justify-center">
                                                                                    <i class="fas fa-flag-checkered text-xs text-gray-400"></i>
                                                                            </span>
                                    <div class=" bg-gray-50  rounded-lg p-4">
                                        <div class="flex justify-between items-start">
                                            <h4 class="font-semibold text-horizon-800">Delivery at Destination</h4>
                                            <span class="text-sm text-secondary-500"><?php echo e(\Carbon\Carbon::parse($courier->estimated_delivery )->toDayDateTimeString()); ?>

</span>
                                        </div>
                                        <p class="text-secondary-600 mt-1"><?php echo e($courier->destination); ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <!-- Package Details -->
                <div class="bg-white rounded-xl shadow-soft overflow-hidden">
                    <div class="p-6 bg-horizon-50 border-b">
                        <h3 class="font-display text-xl font-bold text-horizon-800 flex items-center">
                            <i class="fas fa-box mr-3 text-gold-600"></i>
                            Package Details
                        </h3>
                    </div>
                    <div class="p-6" x-data="{ showDetails: false }">
                        <!-- Shipment Image -->

                                                <div class="mb-6">
                            <img src="<?php echo e(asset('storage/app/public/' . $courier->photo)); ?>" alt="Shipment Image" class="w-full max-w-md mx-auto rounded-lg border shadow-sm">
                        </div>

                        <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                            <div>
                                <p class="text-sm text-secondary-500 mb-1">Description</p>
                                <p class="font-medium text-horizon-800"><?php echo e($courier->description); ?></p>
                            </div>
                            <div>
                                <p class="text-sm text-secondary-500 mb-1">Shipping Mode</p>
                                <p class="font-medium flex items-center text-horizon-800">
                                                                                                                <i class="fas fa-plane text-horizon-500 mr-2"></i>
                                                                      <?php echo e($courier->shipping_mode); ?>

                                </p>
                            </div>
                            <div>
                                <p class="text-sm text-secondary-500 mb-1">Weight</p>
                                <p class="font-medium text-horizon-800"><?php echo e($courier->weight); ?> kg</p>
                            </div>
                            <div>
                                <p class="text-sm text-secondary-500 mb-1">Quantity</p>
                                <p class="font-medium text-horizon-800"><?php echo e($courier->quantity); ?></p>
                            </div>
                            <div>
                                <p class="text-sm text-secondary-500 mb-1">Carrier</p>
                                <p class="font-medium text-horizon-800"><?php echo e($settings->site_name); ?> DELIVERY</p>
                            </div>
                            <div>
                                <p class="text-sm text-secondary-500 mb-1">Carrier Reference</p>
                                <p class="font-medium text-horizon-800"><?php echo e($settings->site_name); ?></p>
                            </div>
                        </div>

                        <div>
                            <button type="button" @click="showDetails = !showDetails" class="text-gold-600 hover:text-gold-700 font-medium flex items-center">
                                <span x-text="showDetails ? 'Hide Additional Details' : 'Show Additional Details'"></span>
                                <i class="fas ml-2" :class="showDetails ? 'fa-chevron-up' : 'fa-chevron-down'"></i>
                            </button>

                            <div x-show="showDetails" x-collapse class="bg-horizon-50 mt-4 p-6 rounded-lg">
                                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                                    <div>
                                        <p class="text-sm text-secondary-500 mb-1">Payment Mode</p>
                                        <p class="font-medium text-horizon-800">Payment Mode: <?php echo e($courier->payment_mode); ?></p>
                                    </div>
                                    <div class="bg-gold-50 p-4 rounded-lg border border-gold-200">
                                        <p class="text-sm text-gold-600 font-medium mb-1">Total Freight Cost</p>
                                        <p class="font-bold text-2xl text-gold-700">$<?php echo e($courier->freight_cost); ?></p>
                                    </div>
                                    <div class="md:col-span-2">
                                        <p class="text-sm text-secondary-500 mb-2">Estimated Timeline</p>
                                        <div class="space-y-1">
                                            <p class="font-medium text-horizon-800">Dispatch: <?php echo e(\Carbon\Carbon::parse($courier->dispatch_date )->toDayDateTimeString()); ?></p>
                                           <p class="font-medium text-horizon-800">Delivery: <?php echo e(\Carbon\Carbon::parse($courier->estimated_delivery )->toDayDateTimeString()); ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Right Column -->
            <div class="lg:col-span-1 space-y-8">
                <!-- Track Another Shipment -->
                <div class="bg-white rounded-xl shadow-soft overflow-hidden">
                    <div class="p-4 bg-gold-50 border-b">
                        <h3 class="font-display text-lg font-bold text-horizon-800 flex items-center">
                            <i class="fas fa-search mr-2 text-gold-600"></i>
                            Track Another Shipment
                        </h3>
                    </div>
                    <div class="p-6">
                        <form action="<?php echo e(route('track.search')); ?>" method="POST" class="space-y-4">
                             <?php echo csrf_field(); ?>
                                                      <div>
                                <label for="quick-tracking-number" class="block text-sm text-secondary-600 mb-2">Tracking Number</label>
                                <div class="relative">
                                    <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                        <i class="fas fa-search text-gray-400"></i>
                                    </div>
                                    <input type="text" id="quick-tracking-number" name="tracking_code" placeholder="Enter tracking number"
                                        class="w-full pl-10 pr-4 py-3 border border-gray-300 rounded-lg focus:ring-2 focus:ring-gold-500 focus:border-gold-500 outline-none transition-all">
                                </div>
                            </div>
                            <button type="submit" class="w-full bg-horizon-600 hover:bg-horizon-700 text-white font-semibold py-3 px-4 rounded-lg transition-colors flex items-center justify-center">
                                <i class="fas fa-search mr-2"></i> Track Package
                            </button>
                        </form>
                    </div>
                </div>

                <!-- Receiver Information -->
                <div class="bg-white rounded-xl shadow-soft overflow-hidden">
                    <div class="p-4 bg-horizon-50 border-b">
                        <h3 class="font-display text-lg font-bold text-horizon-800 flex items-center">
                            <i class="fas fa-user mr-2 text-gold-600"></i>
                            Receiver Information
                        </h3>
                    </div>
                    <div class="p-6 space-y-4">
                        <div>
                            <p class="text-sm text-secondary-500 mb-1">Name</p>
                          <p class="font-medium text-horizon-800"><?php echo e($courier->receiver_name); ?></p>
                        </div>
                        <div>
                            <p class="text-sm text-secondary-500 mb-1">Email</p>
                            <p class="font-medium text-horizon-800"><?php echo e($courier->receiver_email); ?></p>
                        </div>
                        <div>
                            <p class="text-sm text-secondary-500 mb-1">Contact</p>
                           <p class="font-medium text-horizon-800"><?php echo e($courier->receiver_contact); ?></p>
                        </div>
                        <div>
                            <p class="text-sm text-secondary-500 mb-1">Delivery Address</p>
                          <p class="font-medium text-horizon-800"><?php echo e($courier->receiver_address); ?></p>
                        </div>
                    </div>
                </div>

                <!-- Sender Information -->
                <div class="bg-white rounded-xl shadow-soft overflow-hidden">
                    <div class="p-4 bg-horizon-50 border-b">
                        <h3 class="font-display text-lg font-bold text-horizon-800 flex items-center">
                            <i class="fas fa-user mr-2 text-gold-600"></i>
                            Sender Information
                        </h3>
                    </div>
                    <div class="p-6 space-y-4">
                        <div>
                            <p class="text-sm text-secondary-500 mb-1">Name</p>
                           <p class="font-medium text-horizon-800"><?php echo e($courier->sender_name); ?></p>
                        </div>
                        <div>
                            <p class="text-sm text-secondary-500 mb-1">Email</p>
                          <p class="font-medium text-horizon-800"><?php echo e($courier->sender_email); ?></p>
                        </div>
                        <div>
                            <p class="text-sm text-secondary-500 mb-1">Sender Address</p>
                            <p class="font-medium text-horizon-800"><?php echo e($courier->sender_address); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script>
// Function to copy tracking link
function copyTrackingLink() {
    var copyText = document.getElementById("tracking-url");
    copyText.select();
    copyText.setSelectionRange(0, 99999);
    document.execCommand("copy");

    // Show feedback
    var button = document.querySelector("button.bg-gold-50");
    var originalText = button.innerText;
    button.innerText = "Copied!";
    button.classList.add("bg-green-100", "text-green-600");
    button.classList.remove("bg-gold-50", "text-gold-600");

    setTimeout(function() {
        button.innerText = originalText;
        button.classList.remove("bg-green-100", "text-green-600");
        button.classList.add("bg-gold-50", "text-gold-600");
    }, 2000);
}


</script>

        </div>
    </main>




<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.base', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/jjtechde/public_html/swiftx/resources/views/home/result.blade.php ENDPATH**/ ?>