<form action="<?php echo e(route('courier.updates.store', $courier->id)); ?>" method="POST">
    <?php echo csrf_field(); ?>
    <h4>Add Shipment Update</h4>

    <div class="mb-2">
        <label>Status:</label>
         <?php
    $statuses = [
        'Approved', 'Available', 'Cancelled', 'Customs', 'Delivered', 'Dispenser',
        'Distribution', 'Earring Collection', 'Effective', 'In Transit', 'In warehouse',
        'Invoiced', 'On Hold', 'On route', 'Packaged', 'Pending'
    ];
    $selectedStatus = old('status', $courier->status ?? '');
?>

<select name="status" class="form-control" required>
    <?php $__currentLoopData = $statuses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <option value="<?php echo e($status); ?>" <?php echo e($selectedStatus === $status ? 'selected' : ''); ?>>
            <?php echo e($status); ?>

        </option>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</select>
    </div>

    <div class="mb-2">
        <label>Location:</label>
        <input type="text" name="location" class="form-control" placeholder="e.g. Lagos, Nigeria" required>
    </div>

    <div class="mb-2">
        <label>Comment:</label>
        <textarea name="comment" class="form-control" placeholder="Optional note..."></textarea>
    </div>

    <button type="submit" class="btn btn-primary">Submit Update</button>
</form>

<?php /**PATH /home/jjtechde/public_html/swiftx/resources/views/admin/couriers/partials/update_form.blade.php ENDPATH**/ ?>