<!DOCTYPE html>
<html lang="en" class="scroll-smooth">


<meta http-equiv="content-type" content="text/html;charset=UTF-8" />
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="R4yYIHtAcbaitQ7esZSsWuvCfANlysmRYujXFmVK">
    <meta name="description" content="<?php echo e($settings->site_name); ?> - Professional logistics and shipping company providing worldwide freight solutions">
    <link href="<?php echo e(asset('storage/app/public/' . $settings->favicon)); ?>" rel="apple-touch-icon" sizes="144x144">
    <link href="<?php echo e(asset('storage/app/public/' . $settings->favicon)); ?>" rel="apple-touch-icon" sizes="114x114">
    <link href="<?php echo e(asset('storage/app/public/' . $settings->favicon)); ?>" rel="apple-touch-icon" sizes="72x72">
    <link href="<?php echo e(asset('storage/app/public/' . $settings->favicon)); ?>" rel="apple-touch-icon">
    <link href="<?php echo e(asset('storage/app/public/' . $settings->favicon)); ?>" rel="shortcut icon">

    <title><?php echo e($settings->site_name); ?> - Professional Logistics &amp; Shipping Solutions</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.bunny.net/">
    <link href="https://fonts.bunny.net/css?family=playfair-display:400,500,600,700|montserrat:300,400,500,600,700&amp;display=swap" rel="stylesheet" />

    <!-- Font Awesome -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0-beta3/css/all.min.css">

    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com/"></script>
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        sans: ['Montserrat', 'sans-serif'],
                        display: ['Playfair Display', 'serif'],
                    },
                    colors: {
                        horizon: {
                            50: '#f0f9f5',
                            100: '#daf0e5',
                            200: '#b6e0cc',
                            300: '#84c7a9',
                            400: '#4fa980',
                            500: '#2a8c61',
                            600: '#1e704e',
                            700: '#1a5a40', // Dark green for navigation
                            800: '#184835',
                            900: '#153c2d',
                            950: '#0c2119',
                        },
                        gold: {
                            400: '#fcd34d',
                            500: '#fcb529',
                            600: '#f59e0b',
                        },
                        secondary: {
                            50: '#f8fafc',
                            100: '#f1f5f9',
                            200: '#e2e8f0',
                            300: '#cbd5e1',
                            400: '#94a3b8',
                            500: '#64748b',
                            600: '#475569',
                            700: '#334155',
                            800: '#1e293b',
                            900: '#0f172a',
                            950: '#020617',
                        },
                    },
                    animation: {
                        'fade-in': 'fadeIn 0.5s ease-in-out',
                        'slide-up': 'slideUp 0.5s ease-out',
                        'slide-down': 'slideDown 0.3s ease-out',
                        'scale': 'scale 0.3s ease-in-out',
                        'bounce-slow': 'bounce 3s infinite',
                    },
                    keyframes: {
                        fadeIn: {
                            '0%': { opacity: '0' },
                            '100%': { opacity: '1' },
                        },
                        slideUp: {
                            '0%': { transform: 'translateY(10px)', opacity: '0' },
                            '100%': { transform: 'translateY(0)', opacity: '1' },
                        },
                        slideDown: {
                            '0%': { transform: 'translateY(-10px)', opacity: '0' },
                            '100%': { transform: 'translateY(0)', opacity: '1' },
                        },
                        scale: {
                            '0%': { transform: 'scale(0.95)', opacity: '0' },
                            '100%': { transform: 'scale(1)', opacity: '1' },
                        },
                    },
                    boxShadow: {
                        'soft': '0 2px 15px -3px rgba(0, 0, 0, 0.07), 0 10px 20px -2px rgba(0, 0, 0, 0.04)',
                    },
                },
            },
        }
    </script>

    <!-- jQuery -->
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script src="//unpkg.com/alpinejs" defer></script>

    <style>
        [x-cloak] { display: none !important; }

        /* Smooth scrolling */
        html {
            scroll-behavior: smooth;
        }

        /* Custom scrollbar */
        ::-webkit-scrollbar {
            width: 8px;
            height: 8px;
        }

        ::-webkit-scrollbar-track {
            background: #f1f5f9;
        }

        ::-webkit-scrollbar-thumb {
            background: #94a3b8;
            border-radius: 4px;
        }

        ::-webkit-scrollbar-thumb:hover {
            background: #64748b;
        }
    </style>
</head>
<body class="font-sans antialiased min-h-screen flex flex-col bg-white text-secondary-900">
    <!-- Top Bar -->
    <div class="bg-horizon-800 text-white py-2 hidden md:block">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex justify-between items-center text-sm">
                <div class="flex items-center space-x-6">
                    <a href="mailto:<?php echo e($settings->contact_email); ?>" class="flex items-center hover:text-gold-400 transition-colors duration-200">
                        <i class="fas fa-envelope mr-2"></i>
                        <?php echo e($settings->contact_email); ?>

                    </a>
                </div>
                <div class="flex items-center space-x-4">
                    <span class="text-gold-400">Follow us:</span>
                    <a href="#" class="hover:text-gold-400 transition-colors duration-200">
                        <i class="fab fa-facebook-f"></i>
                        <span class="ml-1 hidden lg:inline">Facebook</span>
                    </a>
                    <a href="#" class="hover:text-gold-400 transition-colors duration-200">
                        <i class="fab fa-twitter"></i>
                        <span class="ml-1 hidden lg:inline">Twitter</span>
                    </a>
                    <a href="#" class="hover:text-gold-400 transition-colors duration-200">
                        <i class="fab fa-linkedin-in"></i>
                        <span class="ml-1 hidden lg:inline">LinkedIn</span>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Header -->
    <header class="sticky top-0 z-50 transition-all duration-300 bg-horizon-700 shadow-lg">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between h-20">
                <!-- Logo -->
                <div class="flex-shrink-0">
                    <a href="index" class="flex items-center">

             <?php
              $parts = explode(' ', $settings->site_name);
         ?>


                        <span class="font-display text-2xl md:text-3xl font-bold text-white tracking-wide">
                            <?php echo e($parts[0] ?? ''); ?> <span class="text-gold-500"><?php echo e($parts[1] ?? ''); ?> <?php echo e($parts[2] ?? ''); ?> <?php echo e($parts[3] ?? ''); ?> <?php echo e($parts[4] ?? ''); ?> <?php echo e($parts[5] ?? ''); ?> <?php echo e($parts[6] ?? ''); ?> <?php echo e($parts[7] ?? ''); ?> <?php echo e($parts[8] ?? ''); ?> <?php echo e($parts[9] ?? ''); ?> <?php echo e($parts[10] ?? ''); ?> <?php echo e($parts[11] ?? ''); ?> <?php echo e($parts[13] ?? ''); ?></span>
                        </span>
                    </a>
                </div>

                <!-- Desktop Navigation -->
                <nav class="hidden md:flex items-center space-x-8">
                    <a href="index" class="text-white hover:text-gold-400 text-base font-medium tracking-wide transition-colors duration-200">
                        Home
                    </a>
                    <a href="logistics" class="text-white hover:text-gold-400 text-base font-medium tracking-wide transition-colors duration-200">
                        Logistics
                    </a>
                    <a href="services" class="text-white hover:text-gold-400 text-base font-medium tracking-wide transition-colors duration-200">
                        Services
                    </a>
                    <a href="about" class="text-white hover:text-gold-400 text-base font-medium tracking-wide transition-colors duration-200">
                        About
                    </a>
                    <a href="contact" class="text-white hover:text-gold-400 text-base font-medium tracking-wide transition-colors duration-200">
                        Contact
                    </a>
                </nav>

                <!-- Get Quote Button (Desktop) -->
                <div class="hidden md:block">
                    <a href="track" class="inline-flex items-center px-6 py-2 border border-transparent text-base font-medium rounded-md text-horizon-700 bg-gold-500 hover:bg-gold-600 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gold-500 transition-colors duration-200">
                        TRACK
                    </a>
                </div>

                <!-- Mobile Menu Button -->
                <div class="md:hidden">
                    <button id="mobile-menu-button" class="text-white hover:text-gold-400 focus:outline-none">
                        <svg class="h-6 w-6" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16" />
                        </svg>
                    </button>
                </div>
            </div>
        </div>

        <!-- Mobile Menu -->
        <div id="mobile-menu" class="md:hidden bg-horizon-700 shadow-lg hidden">
            <div class="px-2 pt-2 pb-3 space-y-1">
                <a href="index" class="block px-3 py-2 rounded-md text-base font-medium text-white hover:bg-horizon-600 transition-colors duration-200">
                    Home
                </a>
                <a href="logistics" class="block px-3 py-2 rounded-md text-base font-medium text-white hover:bg-horizon-600 transition-colors duration-200">
                    Logistics
                </a>
                <a href="services" class="block px-3 py-2 rounded-md text-base font-medium text-white hover:bg-horizon-600 transition-colors duration-200">
                    Services
                </a>
                <a href="about" class="block px-3 py-2 rounded-md text-base font-medium text-white hover:bg-horizon-600 transition-colors duration-200">
                    About
                </a>
                <a href="contact" class="block px-3 py-2 rounded-md text-base font-medium text-white hover:bg-horizon-600 transition-colors duration-200">
                    Contact
                </a>
                <div class="pt-4">
                    <a href="track" class="block w-full text-center px-3 py-2 rounded-md text-base font-medium text-horizon-700 bg-gold-500 hover:bg-gold-600 transition-colors duration-200">
                        TRACK
                    </a>
                </div>
            </div>
        </div>
    </header>

    <?php echo $__env->yieldContent('content'); ?>

    <!-- Footer -->
    <footer class="bg-horizon-800 text-white mt-16">
        <div class="container mx-auto px-4 sm:px-6 lg:px-8 py-12">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                <!-- Company Info -->
                <div class="col-span-1 md:col-span-2 lg:col-span-1">
                    <a href="index" class="inline-block mb-6">
                        <span class="font-display text-2xl font-bold text-white">
                           <?php echo e($settings->site_name); ?> <span class="text-gold-500">FREIGHT</span>
                        </span>
                    </a>
                    <div class="space-y-2 text-gray-300">
                        <p>
                            <a href="mailto:<?php echo e($settings->contact_email); ?>" class="hover:text-gold-400 transition-colors duration-200">

                            </a>
                        </p>
                        <p>  <?php echo e($settings->locations); ?></p>
                    </div>
                </div>

                <!-- Quick Links -->
                <div>
                    <h3 class="text-lg font-semibold text-gold-400 mb-6">Quick Links</h3>
                    <ul class="space-y-3">
                        <li>
                            <a href="logistics" class="text-gray-300 hover:text-gold-400 transition-colors duration-200">
                                Logistics
                            </a>
                        </li>
                        <li>
                            <a href="services" class="text-gray-300 hover:text-gold-400 transition-colors duration-200">
                                Services
                            </a>
                        </li>
                        <li>
                            <a href="about" class="text-gray-300 hover:text-gold-400 transition-colors duration-200">
                                About
                            </a>
                        </li>
                        <li>
                            <a href="contact" class="text-gray-300 hover:text-gold-400 transition-colors duration-200">
                                Contact
                            </a>
                        </li>
                    </ul>
                </div>

                <!-- Services -->
                <div>
                    <h3 class="text-lg font-semibold text-gold-400 mb-6">Services</h3>
                    <ul class="space-y-3">
                        <li>
                            <a href="#" class="text-gray-300 hover:text-gold-400 transition-colors duration-200">
                                Air Freight
                            </a>
                        </li>
                        <li>
                            <a href="#" class="text-gray-300 hover:text-gold-400 transition-colors duration-200">
                                Ocean Freight
                            </a>
                        </li>
                        <li>
                            <a href="#" class="text-gray-300 hover:text-gold-400 transition-colors duration-200">
                                Road Transport
                            </a>
                        </li>
                        <li>
                            <a href="#" class="text-gray-300 hover:text-gold-400 transition-colors duration-200">
                                Warehousing
                            </a>
                        </li>
                    </ul>
                </div>

                <!-- Newsletter -->
                <div>
                    <h3 class="text-lg font-semibold text-gold-400 mb-6">Subscribe Newsletter</h3>
                    <form action="#" class="space-y-4">
                        <input type="email" placeholder="Enter your email address..." class="w-full px-4 py-2 bg-horizon-700 border border-horizon-600 rounded-md text-white placeholder-gray-400 focus:outline-none focus:ring-2 focus:ring-gold-500 focus:border-gold-500">
                        <button type="submit" class="w-full px-4 py-2 bg-gold-500 hover:bg-gold-600 text-horizon-800 font-medium rounded-md transition-colors duration-200 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-gold-500">
                            Subscribe
                        </button>
                    </form>
                </div>
            </div>

            <!-- Copyright -->
            <div class="mt-12 pt-8 border-t border-horizon-700 text-center">
                <p class="text-gray-400">&copy;  <?php echo e($settings->twak); ?> <?php echo e($settings->site_name); ?>. All Rights Reserved.</p>
            </div>
        </div>
    </footer>

    <!-- Back to top button -->
    <button
        id="back-to-top"
        class="fixed bottom-6 right-6 p-3 rounded-full bg-gold-500 text-horizon-700 shadow-lg transform transition-transform duration-300 hover:scale-110 focus:outline-none hidden"
    >
        <svg xmlns="http://www.w3.org/2000/svg" class="h-6 w-6" fill="none" viewBox="0 0 24 24" stroke="currentColor">
            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 10l7-7m0 0l7 7m-7-7v18" />
        </svg>
    </button>

    <script>
        $(document).ready(function() {
            // Mobile menu toggle
            $('#mobile-menu-button').click(function() {
                $('#mobile-menu').slideToggle();
            });

            // Back to top button
            $(window).scroll(function() {
                if ($(this).scrollTop() > 300) {
                    $('#back-to-top').fadeIn();
                } else {
                    $('#back-to-top').fadeOut();
                }
            });

            $('#back-to-top').click(function() {
                $('html, body').animate({scrollTop: 0}, 800);
                return false;
            });
        });
    </script>
</body>

 <?php if($settings->tido): ?>
        <script src="//code.tidio.co/<?php echo e($settings->tido); ?>.js" async></script>
    <?php endif; ?>

<?php echo $__env->make('livechat', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

</html>
<?php /**PATH /home/jjtechde/public_html/swiftx/resources/views/layouts/base.blade.php ENDPATH**/ ?>