@extends('layouts.base')

@section('title', 'Contact us')

@section('styles')
    @parent

@endsection
@inject('content', 'App\Http\Controllers\FrontController')
@section('content')



    <!-- Page Content -->
    <main class="flex-grow">
        <div class="animate-fade-in">
            <!-- Hero Section -->
<section class="relative h-96 flex items-center justify-center overflow-hidden">
    <div class="absolute inset-0 bg-gradient-to-r from-horizon-900/90 to-horizon-700/70 z-10"></div>
    <div class="absolute inset-0">
        <img src="https://images.unsplash.com/photo-1553413077-190dd305871c?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
             alt="Contact {{$settings->site_name}}"
             class="w-full h-full object-cover">
    </div>

    <div class="relative z-20 text-center text-white px-4 sm:px-6 lg:px-8">
        <h1 class="font-display text-4xl md:text-6xl font-bold mb-4 animate-slide-up">
            Contact <span class="text-gold-400">Us</span>
        </h1>
        <p class="text-xl mb-4 animate-slide-up" style="animation-delay: 0.2s;">
            We'd love to hear from you
        </p>
        <p class="text-lg animate-slide-up" style="animation-delay: 0.4s;">
            Get in touch with our logistics experts today
        </p>
    </div>
</section>

<!-- Contact Information Section -->
<section class="py-16 lg:py-24">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <div class="inline-flex items-center justify-center w-16 h-16 bg-gold-100 rounded-full mb-6">
                <i class="fas fa-map-marker-alt text-2xl text-gold-600"></i>
            </div>
            <h2 class="font-display text-3xl md:text-4xl font-bold text-horizon-800 mb-4">
                Get in <span class="text-gold-600">Touch</span>
            </h2>
            <p class="text-lg text-secondary-600 max-w-2xl mx-auto">
                Please send your enquiry to <a href="mailto:{{$settings->contact_email}}" class="text-gold-600 hover:text-gold-700 underline">{{$settings->contact_email}}</a>, or contact us using the details below.
            </p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mb-16">
            <!-- Head Office -->
            <div class="bg-white rounded-lg shadow-soft p-8 text-center hover:shadow-lg transition-shadow duration-300">
                <div class="w-16 h-16 bg-horizon-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-building text-2xl text-horizon-600"></i>
                </div>
                <h3 class="font-display text-xl font-bold text-horizon-800 mb-4">Head Office</h3>
                <div class="text-secondary-600 mb-6">


                    @php
    $parts = explode(' ', $settings->locations);
@endphp


                    <p class="mb-2">{{ $parts[0] ?? '' }}.</p>
                    <p class="mb-4">{{ $parts[1] ?? '' }} {{ $parts[2] ?? '' }} {{ $parts[3] ?? '' }} {{ $parts[4] ?? '' }} {{ $parts[5] ?? '' }} {{ $parts[6] ?? '' }} {{ $parts[7] ?? '' }} {{ $parts[8] ?? '' }} {{ $parts[9] ?? '' }} {{ $parts[8] ?? '' }}</p>
                    <p class="mb-2">
                        <a href="mailto:{{$settings->contact_email}}" class="text-gold-600 hover:text-gold-700">
                           {{$settings->contact_email}}
                        </a>
                    </p>
                </div>
                <a href="https://www.google.com/maps/search/?api=1&amp;query={{ $settings->locations}}"
                   target="_blank"
                   class="inline-flex items-center px-6 py-2 bg-gold-500 hover:bg-gold-600 text-white font-medium rounded-lg transition-colors duration-200">
                    <i class="fas fa-map-marker-alt mr-2"></i>
                    Find Us on Map
                </a>
            </div>

            <!-- Customer Service -->
            <div class="bg-white rounded-lg shadow-soft p-8 text-center hover:shadow-lg transition-shadow duration-300">
                <div class="w-16 h-16 bg-gold-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-headset text-2xl text-gold-600"></i>
                </div>
                <h3 class="font-display text-xl font-bold text-horizon-800 mb-4">Customer Service</h3>
                <div class="text-secondary-600 mb-6">
                    <p class="mb-2">24/7 Support Available</p>
                    <p class="mb-4">Monday - Sunday</p>
                    <p class="mb-2">
                        <a href="mailto:{{$settings->contact_email}}" class="text-gold-600 hover:text-gold-700">
                           {{$settings->contact_email}}
                        </a>
                    </p>
                </div>
                <a href="mailto: {{$settings->contact_email}}"
                   class="inline-flex items-center px-6 py-2 bg-horizon-600 hover:bg-horizon-700 text-white font-medium rounded-lg transition-colors duration-200">
                    <i class="fas fa-envelope mr-2"></i>
                    Send Email
                </a>
            </div>

            <!-- Emergency Contact -->
            <div class="bg-white rounded-lg shadow-soft p-8 text-center hover:shadow-lg transition-shadow duration-300 md:col-span-2 lg:col-span-1">
                <div class="w-16 h-16 bg-red-100 rounded-full flex items-center justify-center mx-auto mb-6">
                    <i class="fas fa-exclamation-triangle text-2xl text-red-600"></i>
                </div>
                <h3 class="font-display text-xl font-bold text-horizon-800 mb-4">Emergency Contact</h3>
                <div class="text-secondary-600 mb-6">
                    <p class="mb-2">For urgent shipment issues</p>
                    <p class="mb-4">Available 24/7</p>
                    <p class="mb-2">
                        <a href="mailto:{{$settings->emailfrom}}" class="text-red-600 hover:text-red-700">
                            {{$settings->emailfrom}}
                        </a>
                    </p>
                </div>
                <a href="mailto:"
                   class="inline-flex items-center px-6 py-2 bg-red-500 hover:bg-red-600 text-white font-medium rounded-lg transition-colors duration-200">
                    <i class="fas fa-phone mr-2"></i>
                    Emergency Contact
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Contact Form Section -->
<section class="py-16 lg:py-24 bg-gradient-to-br from-horizon-50 to-gold-50">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-start">
            <!-- Form Header -->
            <div>
                <div class="mb-6">
                    <span class="text-gold-600 font-semibold text-lg">Have Any Question?</span>
                </div>
                <h2 class="font-display text-3xl md:text-4xl font-bold text-horizon-800 mb-6">
                    If you would like to know more <br>
                    about our services, please contact <br>
                    us using this <span class="text-gold-600">form</span>
                </h2>
                <p class="text-lg text-secondary-600 mb-8">
                    Our team of logistics experts is ready to help you find the perfect shipping solution for your needs. Get a response within 24 hours.
                </p>

                <!-- Contact Features -->
                <div class="space-y-4">
                    <div class="flex items-center space-x-3">
                        <div class="w-8 h-8 bg-gold-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-check text-gold-600 text-sm"></i>
                        </div>
                        <span class="text-secondary-700">Free consultation and quote</span>
                    </div>
                    <div class="flex items-center space-x-3">
                        <div class="w-8 h-8 bg-gold-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-check text-gold-600 text-sm"></i>
                        </div>
                        <span class="text-secondary-700">24-hour response guarantee</span>
                    </div>
                    <div class="flex items-center space-x-3">
                        <div class="w-8 h-8 bg-gold-100 rounded-full flex items-center justify-center">
                            <i class="fas fa-check text-gold-600 text-sm"></i>
                        </div>
                        <span class="text-secondary-700">Expert logistics advice</span>
                    </div>
                </div>
            </div>

            <!-- Contact Form -->
            <div class="bg-white rounded-lg shadow-soft p-8">
                <form action="{{ route('enquiry') }}" method="POST" class="space-y-6">

                       @csrf
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="first_name" class="block text-sm font-medium text-horizon-800 mb-2">First Name *</label>
                            <input type="text"
                                   id="first_name"
                                   name="name"
                                   required
                                   class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-gold-500 focus:border-gold-500 transition-colors duration-200"
                                   placeholder="Enter your first name">
                        </div>

                        <div>
                            <label for="last_name" class="block text-sm font-medium text-horizon-800 mb-2">Last Name *</label>
                            <input type="text"
                                   id="last_name"
                                   name="last_name"
                                   required
                                   class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-gold-500 focus:border-gold-500 transition-colors duration-200"
                                   placeholder="Enter your last name">
                        </div>
                    </div>

                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div>
                            <label for="email" class="block text-sm font-medium text-horizon-800 mb-2">Email Address *</label>
                            <input type="email"
                                   id="email"
                                   name="email"
                                   required
                                   class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-gold-500 focus:border-gold-500 transition-colors duration-200"
                                   placeholder="Enter your email address">
                        </div>

                        <div>
                            <label for="phone" class="block text-sm font-medium text-horizon-800 mb-2">Phone Number</label>
                            <input type="tel"
                                   id="phone"
                                   name="phone"
                                   class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-gold-500 focus:border-gold-500 transition-colors duration-200"
                                   placeholder="Enter your phone number">
                        </div>
                    </div>

                    <div>
                        <label for="company" class="block text-sm font-medium text-horizon-800 mb-2">Company Name</label>
                        <input type="text"
                               id="company"
                               name="subject"
                               class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-gold-500 focus:border-gold-500 transition-colors duration-200"
                               placeholder="Enter your company name">
                    </div>

                    <div>
                        <label for="service_type" class="block text-sm font-medium text-horizon-800 mb-2">Service Interest</label>
                        <select id="service_type"
                                name="service_type"
                                class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-gold-500 focus:border-gold-500 transition-colors duration-200">
                            <option value="">Select a service</option>
                            <option value="air_freight">Air Freight</option>
                            <option value="ocean_freight">Ocean Freight</option>
                            <option value="road_transport">Road Transport</option>
                            <option value="warehousing">Warehousing</option>
                            <option value="supply_chain">Supply Chain Management</option>
                            <option value="other">Other</option>
                        </select>
                    </div>

                    <div>
                        <label for="message" class="block text-sm font-medium text-horizon-800 mb-2">Message *</label>
                        <textarea id="message"
                                  name="message"
                                  rows="5"
                                  required
                                  class="w-full px-4 py-3 border border-gray-300 rounded-lg focus:outline-none focus:ring-2 focus:ring-gold-500 focus:border-gold-500 transition-colors duration-200 resize-vertical"
                                  placeholder="Tell us about your shipping needs..."></textarea>
                    </div>

                    <div class="flex items-start space-x-3">
                        <input type="checkbox"
                               id="newsletter"
                               name="newsletter"
                               class="mt-1 text-gold-500 focus:ring-gold-500 border-gray-300 rounded">
                        <label for="newsletter" class="text-sm text-secondary-600">
                            I would like to receive updates about {{$settings->site_name}} services and industry news.
                        </label>
                    </div>

                    <button type="submit"
                            class="w-full px-8 py-4 bg-gradient-to-r from-horizon-600 to-horizon-700 hover:from-horizon-700 hover:to-horizon-800 text-white font-semibold rounded-lg transition-all duration-300 transform hover:scale-105 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-horizon-500">
                        <i class="fas fa-paper-plane mr-2"></i>
                        Send Message
                    </button>
                </form>
            </div>
        </div>
    </div>
</section>
@php
    $encodedAddress = urlencode($settings->locations);
    $mapUrl = "https://www.google.com/maps?q={$encodedAddress}&output=embed";
@endphp

<!-- Map Section -->
<div class="relative h-96 lg:h-[500px]">
    <div class="absolute inset-0 z-10">
        <iframe
            src="{{ $mapUrl }}"
            width="100%"
            height="100%"
            style="border:0;"
            allowfullscreen=""
            loading="lazy"
            referrerpolicy="no-referrer-when-downgrade"
            class="grayscale hover:grayscale-0 transition-all duration-300">
        </iframe>
    </div>



    <!-- Map Overlay -->
    <div class="absolute top-6 left-6 bg-white/95 backdrop-blur-sm rounded-lg p-6 shadow-lg z-20 max-w-sm">
        <h3 class="font-display text-lg font-bold text-horizon-800 mb-2">Visit Our Office</h3>
        <div class="text-secondary-600 text-sm">
            <p class="mb-2">{{ $parts[0] ?? '' }} {{ $parts[1] ?? '' }}  {{ $parts[2] ?? '' }}</p>
                    <p class="mb-4"> {{ $parts[3] ?? '' }} {{ $parts[4] ?? '' }} {{ $parts[5] ?? '' }} {{ $parts[6] ?? '' }} {{ $parts[7] ?? '' }} {{ $parts[8] ?? '' }} {{ $parts[9] ?? '' }} {{ $parts[8] ?? '' }}</p>
            <div class="flex items-center space-x-4 text-xs">
                <span class="flex items-center">
                    <i class="fas fa-clock text-gold-600 mr-1"></i>
                    24/7 Support
                </span>
                <span class="flex items-center">
                    <i class="fas fa-phone text-horizon-600 mr-1"></i>
                    Available
                </span>
            </div>
        </div>
    </div>
</section>

<!-- FAQ Section -->
<section class="py-16 lg:py-24">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="font-display text-3xl md:text-4xl font-bold text-horizon-800 mb-4">
                Frequently Asked <span class="text-gold-600">Questions</span>
            </h2>
            <p class="text-lg text-secondary-600 max-w-2xl mx-auto">
                Quick answers to common questions about our logistics services
            </p>
        </div>

        <div class="max-w-3xl mx-auto space-y-4" x-data="{selected:1}">
            <!-- FAQ 1 -->
            <div class="border border-gray-200 rounded-lg overflow-hidden bg-white shadow-sm">
                <button
                    @click="selected !== 1 ? selected = 1 : selected = null"
                    class="flex justify-between items-center w-full px-6 py-4 text-left text-horizon-800 font-semibold hover:bg-gray-50 focus:outline-none transition-colors duration-200"
                >
                    <span>How do I track my shipment?</span>
                    <svg
                        :class="{'rotate-180': selected === 1}"
                        class="h-5 w-5 text-gold-600 transform transition-transform duration-200"
                        xmlns="http://www.w3.org/2000/svg"
                        viewBox="0 0 20 20"
                        fill="currentColor"
                    >
                        <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                    </svg>
                </button>
                <div
                    x-show="selected === 1"
                    x-transition:enter="transition ease-out duration-200"
                    x-transition:enter-start="opacity-0 transform -translate-y-4"
                    x-transition:enter-end="opacity-100 transform translate-y-0"
                    x-transition:leave="transition ease-in duration-150"
                    x-transition:leave-start="opacity-100 transform translate-y-0"
                    x-transition:leave-end="opacity-0 transform -translate-y-4"
                    class="px-6 py-4 bg-gray-50 text-secondary-700"
                >
                    You can track your shipment using our online tracking system. Simply visit our tracking page and enter your tracking number to get real-time updates on your shipment's location and status.
                </div>
            </div>

            <!-- FAQ 2 -->
            <div class="border border-gray-200 rounded-lg overflow-hidden bg-white shadow-sm">
                <button
                    @click="selected !== 2 ? selected = 2 : selected = null"
                    class="flex justify-between items-center w-full px-6 py-4 text-left text-horizon-800 font-semibold hover:bg-gray-50 focus:outline-none transition-colors duration-200"
                >
                    <span>What shipping services do you offer?</span>
                    <svg
                        :class="{'rotate-180': selected === 2}"
                        class="h-5 w-5 text-gold-600 transform transition-transform duration-200"
                        xmlns="http://www.w3.org/2000/svg"
                        viewBox="0 0 20 20"
                        fill="currentColor"
                    >
                        <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                    </svg>
                </button>
                <div
                    x-show="selected === 2"
                    x-transition:enter="transition ease-out duration-200"
                    x-transition:enter-start="opacity-0 transform -translate-y-4"
                    x-transition:enter-end="opacity-100 transform translate-y-0"
                    x-transition:leave="transition ease-in duration-150"
                    x-transition:leave-start="opacity-100 transform translate-y-0"
                    x-transition:leave-end="opacity-0 transform -translate-y-4"
                    class="px-6 py-4 bg-gray-50 text-secondary-700"
                >
                    We offer comprehensive logistics services including air freight, ocean freight, road transport, warehousing, supply chain management, and customs clearance. Our services cover both domestic and international shipping.
                </div>
            </div>

            <!-- FAQ 3 -->
            <div class="border border-gray-200 rounded-lg overflow-hidden bg-white shadow-sm">
                <button
                    @click="selected !== 3 ? selected = 3 : selected = null"
                    class="flex justify-between items-center w-full px-6 py-4 text-left text-horizon-800 font-semibold hover:bg-gray-50 focus:outline-none transition-colors duration-200"
                >
                    <span>How do I get a shipping quote?</span>
                    <svg
                        :class="{'rotate-180': selected === 3}"
                        class="h-5 w-5 text-gold-600 transform transition-transform duration-200"
                        xmlns="http://www.w3.org/2000/svg"
                        viewBox="0 0 20 20"
                        fill="currentColor"
                    >
                        <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                    </svg>
                </button>
                <div
                    x-show="selected === 3"
                    x-transition:enter="transition ease-out duration-200"
                    x-transition:enter-start="opacity-0 transform -translate-y-4"
                    x-transition:enter-end="opacity-100 transform translate-y-0"
                    x-transition:leave="transition ease-in duration-150"
                    x-transition:leave-start="opacity-100 transform translate-y-0"
                    x-transition:leave-end="opacity-0 transform -translate-y-4"
                    class="px-6 py-4 bg-gray-50 text-secondary-700"
                >
                    You can request a quote by filling out our contact form above, calling our customer service team, or using our online quote calculator. We'll provide you with a detailed quote within 24 hours.
                </div>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-16 bg-gradient-to-r from-horizon-700 to-horizon-800 text-white">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="font-display text-3xl md:text-4xl font-bold mb-4">
            Ready to Ship with {{$settings->site_name}}?
        </h2>
        <p class="text-lg mb-8 text-gray-200 max-w-2xl mx-auto">
            Get started today with our comprehensive logistics solutions. Our team is ready to help you with all your shipping needs.
        </p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="#"
               class="inline-flex items-center justify-center px-8 py-3 bg-gold-500 hover:bg-gold-600 text-horizon-800 font-semibold rounded-lg transition-colors duration-200">
                Get Free Quote
                <i class="fas fa-calculator ml-2"></i>
            </a>
            <a href="track"
               class="inline-flex items-center justify-center px-8 py-3 border-2 border-white text-white hover:bg-white hover:text-horizon-800 font-semibold rounded-lg transition-colors duration-200">
                Track Shipment
                <i class="fas fa-search ml-2"></i>
            </a>
        </div>
    </div>
</section>

<script src="https://unpkg.com/alpinejs%403.14.9/dist/cdn.min.js" defer></script>
        </div>
    </main>






@endsection
