@extends('layouts.base')

@section('title', 'About Us')



@inject('content', 'App\Http\Controllers\FrontController')
@section('content')




    <!-- Page Content -->
    <main class="flex-grow">
        <div class="animate-fade-in">
            <!-- Hero Section -->
<section class="relative h-screen flex items-center justify-center overflow-hidden">
    <div class="absolute inset-0 bg-gradient-to-r from-horizon-900/90 to-horizon-700/70 z-10"></div>
    <div class="absolute inset-0">
        <img src="https://images.unsplash.com/photo-1494412574643-ff11b0a5c1c3?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
             alt="About {{$settings->site_name}}"
             class="w-full h-full object-cover">
    </div>

    <div class="relative z-20 text-center text-white px-4 sm:px-6 lg:px-8">
        <h1 class="font-display text-4xl md:text-6xl lg:text-7xl font-bold mb-6 animate-slide-up">
            About <span class="text-gold-400">{{$settings->site_name}}</span>
        </h1>
        <p class="text-xl md:text-2xl mb-8 max-w-3xl mx-auto animate-slide-up" style="animation-delay: 0.2s;">
            Everyone within our business understands our mission
        </p>
        <p class="text-lg mb-8 max-w-2xl mx-auto animate-slide-up" style="animation-delay: 0.4s;">
            It means we don't just come to work to do a job, we come to work to make a difference.
        </p>
    </div>
</section>

<!-- Mission Statement Section -->
<section class="relative py-16 lg:py-24 overflow-hidden">
    <div class="absolute inset-0">
        <img src="https://images.unsplash.com/photo-1566576912321-d58ddd7a6088?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
             alt="Our Mission"
             class="w-full h-full object-cover">
    </div>
    <div class="absolute inset-0 bg-horizon-900/80"></div>

    <div class="relative z-10 container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="max-w-4xl mx-auto text-center">
            <div class="bg-white/95 backdrop-blur-sm rounded-2xl p-8 md:p-12 shadow-2xl">
                <div class="text-6xl text-gold-500 mb-6">"</div>
                <blockquote class="font-display text-2xl md:text-3xl font-bold text-horizon-800 mb-6 leading-relaxed">
                    To make the process of buying and managing shipping and logistics services simple, efficient, stress free and cost effective.
                </blockquote>
                <p class="text-lg text-secondary-600 leading-relaxed">
                    We do this by providing a friendly, efficient and personalised service combined with innovative IT solutions that enable our customers to always be in control of their supply chains.
                </p>
            </div>
        </div>
    </div>
</section>

<!-- Our Values Section -->
<section class="py-16 lg:py-24">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-start">
            <!-- Values Header -->
            <div>
                <div class="mb-6">
                    <span class="text-gold-600 font-semibold text-lg">Our Values</span>
                </div>
                <h2 class="font-display text-3xl md:text-4xl lg:text-5xl font-bold text-horizon-800 mb-6">
                    Giving customers <br>
                    a unique experience <br>
                    of <span class="text-gold-600">partnership</span>.
                </h2>
            </div>

            <!-- Values Accordion -->
            <div class="space-y-4" x-data="{selected:1}">
                <!-- Value 1 -->
                <div class="border border-gray-200 rounded-lg overflow-hidden bg-white shadow-sm">
                    <button
                        @click="selected !== 1 ? selected = 1 : selected = null"
                        class="flex justify-between items-center w-full px-6 py-4 text-left text-horizon-800 font-semibold hover:bg-gray-50 focus:outline-none transition-colors duration-200"
                    >
                        <span>Provide a service we are proud of</span>
                        <svg
                            :class="{'rotate-180': selected === 1}"
                            class="h-5 w-5 text-gold-600 transform transition-transform duration-200"
                            xmlns="http://www.w3.org/2000/svg"
                            viewBox="0 0 20 20"
                            fill="currentColor"
                        >
                            <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                        </svg>
                    </button>
                    <div
                        x-show="selected === 1"
                        x-transition:enter="transition ease-out duration-200"
                        x-transition:enter-start="opacity-0 transform -translate-y-4"
                        x-transition:enter-end="opacity-100 transform translate-y-0"
                        x-transition:leave="transition ease-in duration-150"
                        x-transition:leave-start="opacity-100 transform translate-y-0"
                        x-transition:leave-end="opacity-0 transform -translate-y-4"
                        class="px-6 py-4 bg-gray-50 text-secondary-700"
                    >
                        We are committed to the long-term, profitable future of our business and aim to achieve sustained growth that provides enhanced value to customers and industry partners and opportunities.
                    </div>
                </div>

                <!-- Value 2 -->
                <div class="border border-gray-200 rounded-lg overflow-hidden bg-white shadow-sm">
                    <button
                        @click="selected !== 2 ? selected = 2 : selected = null"
                        class="flex justify-between items-center w-full px-6 py-4 text-left text-horizon-800 font-semibold hover:bg-gray-50 focus:outline-none transition-colors duration-200"
                    >
                        <span>Support each other and work together</span>
                        <svg
                            :class="{'rotate-180': selected === 2}"
                            class="h-5 w-5 text-gold-600 transform transition-transform duration-200"
                            xmlns="http://www.w3.org/2000/svg"
                            viewBox="0 0 20 20"
                            fill="currentColor"
                        >
                            <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                        </svg>
                    </button>
                    <div
                        x-show="selected === 2"
                        x-transition:enter="transition ease-out duration-200"
                        x-transition:enter-start="opacity-0 transform -translate-y-4"
                        x-transition:enter-end="opacity-100 transform translate-y-0"
                        x-transition:leave="transition ease-in duration-150"
                        x-transition:leave-start="opacity-100 transform translate-y-0"
                        x-transition:leave-end="opacity-0 transform -translate-y-4"
                        class="px-6 py-4 bg-gray-50 text-secondary-700"
                    >
                        We foster a collaborative environment where teamwork and mutual support drive our success. Together, we achieve more than we ever could individually.
                    </div>
                </div>

                <!-- Value 3 -->
                <div class="border border-gray-200 rounded-lg overflow-hidden bg-white shadow-sm">
                    <button
                        @click="selected !== 3 ? selected = 3 : selected = null"
                        class="flex justify-between items-center w-full px-6 py-4 text-left text-horizon-800 font-semibold hover:bg-gray-50 focus:outline-none transition-colors duration-200"
                    >
                        <span>Make long-term business decisions</span>
                        <svg
                            :class="{'rotate-180': selected === 3}"
                            class="h-5 w-5 text-gold-600 transform transition-transform duration-200"
                            xmlns="http://www.w3.org/2000/svg"
                            viewBox="0 0 20 20"
                            fill="currentColor"
                        >
                            <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                        </svg>
                    </button>
                    <div
                        x-show="selected === 3"
                        x-transition:enter="transition ease-out duration-200"
                        x-transition:enter-start="opacity-0 transform -translate-y-4"
                        x-transition:enter-end="opacity-100 transform translate-y-0"
                        x-transition:leave="transition ease-in duration-150"
                        x-transition:leave-start="opacity-100 transform translate-y-0"
                        x-transition:leave-end="opacity-0 transform -translate-y-4"
                        class="px-6 py-4 bg-gray-50 text-secondary-700"
                    >
                        We prioritize sustainable growth and strategic planning that benefits all stakeholders for years to come, not just short-term gains.
                    </div>
                </div>

                <!-- Value 4 -->
                <div class="border border-gray-200 rounded-lg overflow-hidden bg-white shadow-sm">
                    <button
                        @click="selected !== 4 ? selected = 4 : selected = null"
                        class="flex justify-between items-center w-full px-6 py-4 text-left text-horizon-800 font-semibold hover:bg-gray-50 focus:outline-none transition-colors duration-200"
                    >
                        <span>Always seek to improve</span>
                        <svg
                            :class="{'rotate-180': selected === 4}"
                            class="h-5 w-5 text-gold-600 transform transition-transform duration-200"
                            xmlns="http://www.w3.org/2000/svg"
                            viewBox="0 0 20 20"
                            fill="currentColor"
                        >
                            <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                        </svg>
                    </button>
                    <div
                        x-show="selected === 4"
                        x-transition:enter="transition ease-out duration-200"
                        x-transition:enter-start="opacity-0 transform -translate-y-4"
                        x-transition:enter-end="opacity-100 transform translate-y-0"
                        x-transition:leave="transition ease-in duration-150"
                        x-transition:leave-start="opacity-100 transform translate-y-0"
                        x-transition:leave-end="opacity-0 transform -translate-y-4"
                        class="px-6 py-4 bg-gray-50 text-secondary-700"
                    >
                        Continuous improvement is at the heart of everything we do. We constantly evolve our processes, technology, and services to better serve our clients.
                    </div>
                </div>

                <!-- Value 5 -->
                <div class="border border-gray-200 rounded-lg overflow-hidden bg-white shadow-sm">
                    <button
                        @click="selected !== 5 ? selected = 5 : selected = null"
                        class="flex justify-between items-center w-full px-6 py-4 text-left text-horizon-800 font-semibold hover:bg-gray-50 focus:outline-none transition-colors duration-200"
                    >
                        <span>Member of the community</span>
                        <svg
                            :class="{'rotate-180': selected === 5}"
                            class="h-5 w-5 text-gold-600 transform transition-transform duration-200"
                            xmlns="http://www.w3.org/2000/svg"
                            viewBox="0 0 20 20"
                            fill="currentColor"
                        >
                            <path fill-rule="evenodd" d="M5.293 7.293a1 1 0 011.414 0L10 10.586l3.293-3.293a1 1 0 111.414 1.414l-4 4a1 1 0 01-1.414 0l-4-4a1 1 0 010-1.414z" clip-rule="evenodd" />
                        </svg>
                    </button>
                    <div
                        x-show="selected === 5"
                        x-transition:enter="transition ease-out duration-200"
                        x-transition:enter-start="opacity-0 transform -translate-y-4"
                        x-transition:enter-end="opacity-100 transform translate-y-0"
                        x-transition:leave="transition ease-in duration-150"
                        x-transition:leave-start="opacity-100 transform translate-y-0"
                        x-transition:leave-end="opacity-0 transform -translate-y-4"
                        class="px-6 py-4 bg-gray-50 text-secondary-700"
                    >
                        We are proud to be active members of our community, contributing to local economic growth and supporting social responsibility initiatives.
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Statistics Section -->
<section class="py-16 lg:py-24 bg-gradient-to-br from-horizon-50 to-gold-50">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-8">
            <div class="text-center">
                <div class="text-3xl md:text-4xl font-bold text-horizon-700 mb-2" data-count="175">175</div>
                <div class="text-sm text-secondary-600">UK operating centres</div>
            </div>
            <div class="text-center">
                <div class="text-3xl md:text-4xl font-bold text-gold-600 mb-2" data-count="120">120</div>
                <div class="text-sm text-secondary-600">Countries Worldwide</div>
            </div>
            <div class="text-center">
                <div class="text-3xl md:text-4xl font-bold text-horizon-700 mb-2">50<span class="text-lg">K</span></div>
                <div class="text-sm text-secondary-600">Logistics Professionals</div>
            </div>
            <div class="text-center">
                <div class="text-3xl md:text-4xl font-bold text-gold-600 mb-2">450<span class="text-lg">K</span></div>
                <div class="text-sm text-secondary-600">containers of freight</div>
            </div>
            <div class="text-center">
                <div class="text-3xl md:text-4xl font-bold text-horizon-700 mb-2">35<span class="text-lg">K</span></div>
                <div class="text-sm text-secondary-600">Project delivery vehicles</div>
            </div>
            <div class="text-center">
                <div class="text-3xl md:text-4xl font-bold text-gold-600 mb-2">20<span class="text-lg">K</span></div>
                <div class="text-sm text-secondary-600">sq.ft of warehousing</div>
            </div>
        </div>
    </div>
</section>

<!-- Company History Section -->
<section class="py-16 lg:py-24 bg-gradient-to-br from-gold-50 to-horizon-50">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <div class="inline-flex items-center justify-center w-16 h-16 bg-gold-100 rounded-full mb-6">
                <i class="fas fa-history text-2xl text-gold-600"></i>
            </div>
            <h2 class="font-display text-3xl md:text-4xl lg:text-5xl font-bold text-horizon-800 mb-4">
                {{$settings->site_name}} has grown from <br>
                <span class="text-gold-600">strength to strength</span>
            </h2>
            <p class="text-lg text-secondary-600 max-w-2xl mx-auto">
                It means we don't just come to work to do a job, we come to work to make a difference.
            </p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <!-- History Item 1 -->
            <div class="bg-white rounded-lg shadow-soft p-6 hover:shadow-lg transition-shadow duration-300">
                <div class="text-sm text-gold-600 font-semibold mb-2">11-23-2016</div>
                <h3 class="font-display text-lg font-bold text-horizon-800 mb-3">ISO ACCREDITATION</h3>
                <p class="text-secondary-600 text-sm leading-relaxed">
                    In November 2016 after a lot of work Atlas Logistics UK Ltd became ISO 9001 and ISO 27001 accredited, complying with The Provision of Import and Export Solutions and Associated Services.
                </p>
            </div>

            <!-- History Item 2 -->
            <div class="bg-white rounded-lg shadow-soft p-6 hover:shadow-lg transition-shadow duration-300">
                <div class="text-sm text-gold-600 font-semibold mb-2">11-23-2016</div>
                <h3 class="font-display text-lg font-bold text-horizon-800 mb-3">2016 RE BRAND</h3>
                <p class="text-secondary-600 text-sm leading-relaxed">
                    New logo, new website, fresh new brand but still the same reliable team. Follow our blog article for more information.
                </p>
            </div>

            <!-- History Item 3 -->
            <div class="bg-white rounded-lg shadow-soft p-6 hover:shadow-lg transition-shadow duration-300">
                <div class="text-sm text-gold-600 font-semibold mb-2">09-15-2015</div>
                <h3 class="font-display text-lg font-bold text-horizon-800 mb-3">LOGISTICS PVT ACQUIRED</h3>
                <p class="text-secondary-600 text-sm leading-relaxed">
                    In September 2015 the shares of Logistics PVT were acquired by the UK Company, meaning Atlas Logistics expanded its global reach.
                </p>
            </div>

            <!-- History Item 4 -->
            <div class="bg-white rounded-lg shadow-soft p-6 hover:shadow-lg transition-shadow duration-300">
                <div class="text-sm text-gold-600 font-semibold mb-2">03-01-2013</div>
                <h3 class="font-display text-lg font-bold text-horizon-800 mb-3">2013 BOTH OFFICES</h3>
                <p class="text-secondary-600 text-sm leading-relaxed">
                    In March 2013 both offices moved to larger premises, London being strategically placed close to Heathrow Airport, and Birmingham moving to a facility giving access to 30,000 square feet.
                </p>
            </div>

            <!-- History Item 5 -->
            <div class="bg-white rounded-lg shadow-soft p-6 hover:shadow-lg transition-shadow duration-300">
                <div class="text-sm text-gold-600 font-semibold mb-2">06-01-2012</div>
                <h3 class="font-display text-lg font-bold text-horizon-800 mb-3">2012 WCA MEMBERSHIP</h3>
                <p class="text-secondary-600 text-sm leading-relaxed">
                    In June 2012 {{$settings->site_name}} became members of the WCA, the world's largest and most powerful network of independent freight forwarders.
                </p>
            </div>

            <!-- History Item 6 -->
            <div class="bg-white rounded-lg shadow-soft p-6 hover:shadow-lg transition-shadow duration-300">
                <div class="text-sm text-gold-600 font-semibold mb-2">10-01-2009</div>
                <h3 class="font-display text-lg font-bold text-horizon-800 mb-3">LOGISTICS BEGAN TRADING</h3>
                <p class="text-secondary-600 text-sm leading-relaxed">
                    Logistics UK Ltd began trading in October 2009 as an independent company, being associated through share ownership with established partners.
                </p>
            </div>
        </div>
    </div>
</section>

<!-- Industry Expertise Section -->
<section class="py-16 lg:py-24">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="font-display text-3xl md:text-4xl lg:text-5xl font-bold text-horizon-800 mb-4">
                Industry <span class="text-gold-600">Expertise</span>
            </h2>
            <p class="text-lg text-secondary-600 max-w-2xl mx-auto">
                We serve diverse industries with specialized logistics solutions
            </p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <!-- Industry 1 -->
            <div class="bg-white rounded-lg shadow-soft overflow-hidden hover:shadow-lg transition-shadow duration-300">
                <div class="h-48 overflow-hidden">
                    <img src="https://images.unsplash.com/photo-1553413077-190dd305871c?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
                         alt="Postal Services"
                         class="w-full h-full object-cover hover:scale-105 transition-transform duration-300">
                </div>
                <div class="p-6">
                    <h3 class="font-display text-xl font-bold text-horizon-800 mb-3">Postal</h3>
                    <p class="text-secondary-600 leading-relaxed">
                        Specialized postal and mail logistics services with secure handling and timely delivery across all postal networks.
                    </p>
                </div>
            </div>

            <!-- Industry 2 -->
            <div class="bg-white rounded-lg shadow-soft overflow-hidden hover:shadow-lg transition-shadow duration-300">
                <div class="h-48 overflow-hidden">
                    <img src="https://images.unsplash.com/photo-1601584115197-04ecc0da31d7?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
                         alt="Retail Logistics"
                         class="w-full h-full object-cover hover:scale-105 transition-transform duration-300">
                </div>
                <div class="p-6">
                    <h3 class="font-display text-xl font-bold text-horizon-800 mb-3">Retail</h3>
                    <p class="text-secondary-600 leading-relaxed">
                        Comprehensive retail logistics solutions optimizing the flow of goods from supply chain to store with dynamic optimization.
                    </p>
                </div>
            </div>

            <!-- Industry 3 -->
            <div class="bg-white rounded-lg shadow-soft overflow-hidden hover:shadow-lg transition-shadow duration-300">
                <div class="h-48 overflow-hidden">
                    <img src="https://images.unsplash.com/photo-1586528116311-ad8dd3c8310d?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
                         alt="Industrial Logistics"
                         class="w-full h-full object-cover hover:scale-105 transition-transform duration-300">
                </div>
                <div class="p-6">
                    <h3 class="font-display text-xl font-bold text-horizon-800 mb-3">Industrial</h3>
                    <p class="text-secondary-600 leading-relaxed">
                        Heavy-duty industrial logistics for manufacturing and construction sectors with specialized equipment and handling.
                    </p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Testimonials Section -->
<section class="py-16 lg:py-24 bg-gradient-to-r from-horizon-700 to-horizon-800 text-white">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 md:grid-cols-2 gap-8">
            <!-- Testimonial 1 -->
            <div class="bg-white/10 backdrop-blur-sm rounded-lg p-8">
                <div class="text-4xl text-gold-400 mb-4">"</div>
                <p class="text-lg mb-6 leading-relaxed">
                    As a first time importer from the Far East, the process can be quite daunting. John Good has provided exceptional service and support right through the process.
                </p>
                <div>
                    <h4 class="font-semibold text-gold-400">Steve Macholnad</h4>
                    <p class="text-gray-300">Manager Smart Move LTD</p>
                </div>
            </div>

            <!-- Testimonial 2 -->
            <div class="bg-white/10 backdrop-blur-sm rounded-lg p-8">
                <div class="text-4xl text-gold-400 mb-4">"</div>
                <p class="text-lg mb-6 leading-relaxed">
                    {{$settings->site_name}} has consistently delivered exceptional service. Their attention to detail and commitment to customer satisfaction is unmatched in the industry.
                </p>
                <div>
                    <h4 class="font-semibold text-gold-400">Sarah Johnson</h4>
                    <p class="text-gray-300">Director Global Trade Inc</p>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Accreditations Section -->
<section class="py-16 lg:py-24">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <div class="inline-flex items-center justify-center w-16 h-16 bg-gold-100 rounded-full mb-6">
                <i class="fas fa-certificate text-2xl text-gold-600"></i>
            </div>
            <h2 class="font-display text-3xl md:text-4xl font-bold text-horizon-800 mb-4">
                Our <span class="text-gold-600">Accreditations</span>
            </h2>
            <p class="text-lg text-secondary-600 max-w-2xl mx-auto">
                We are committed to delivering professional services of the highest standard
            </p>
        </div>

        <div class="grid grid-cols-2 md:grid-cols-4 gap-8">
            <div class="bg-white rounded-lg shadow-soft p-6 flex items-center justify-center hover:shadow-lg transition-shadow duration-300">
                <div class="text-center">
                    <div class="w-16 h-16 bg-horizon-100 rounded-full flex items-center justify-center mx-auto mb-3">
                        <i class="fas fa-award text-2xl text-horizon-600"></i>
                    </div>
                    <div class="text-sm font-semibold text-horizon-800">ISO 9001</div>
                </div>
            </div>

            <div class="bg-white rounded-lg shadow-soft p-6 flex items-center justify-center hover:shadow-lg transition-shadow duration-300">
                <div class="text-center">
                    <div class="w-16 h-16 bg-gold-100 rounded-full flex items-center justify-center mx-auto mb-3">
                        <i class="fas fa-shield-alt text-2xl text-gold-600"></i>
                    </div>
                    <div class="text-sm font-semibold text-horizon-800">ISO 27001</div>
                </div>
            </div>

            <div class="bg-white rounded-lg shadow-soft p-6 flex items-center justify-center hover:shadow-lg transition-shadow duration-300">
                <div class="text-center">
                    <div class="w-16 h-16 bg-horizon-100 rounded-full flex items-center justify-center mx-auto mb-3">
                        <i class="fas fa-globe text-2xl text-horizon-600"></i>
                    </div>
                    <div class="text-sm font-semibold text-horizon-800">WCA Member</div>
                </div>
            </div>

            <div class="bg-white rounded-lg shadow-soft p-6 flex items-center justify-center hover:shadow-lg transition-shadow duration-300">
                <div class="text-center">
                    <div class="w-16 h-16 bg-gold-100 rounded-full flex items-center justify-center mx-auto mb-3">
                        <i class="fas fa-check-circle text-2xl text-gold-600"></i>
                    </div>
                    <div class="text-sm font-semibold text-horizon-800">Certified</div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Photo Gallery Section -->
<section class="py-16 lg:py-24 bg-gradient-to-br from-horizon-50 to-gold-50">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="font-display text-3xl md:text-4xl font-bold text-horizon-800 mb-4">
                Our <span class="text-gold-600">Facilities</span>
            </h2>
            <p class="text-lg text-secondary-600 max-w-2xl mx-auto">
                Take a look at our state-of-the-art logistics facilities and operations
            </p>
        </div>

        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
            <div class="lg:col-span-2 lg:row-span-2">
                <img src="https://images.unsplash.com/photo-1566576912321-d58ddd7a6088?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
                     alt="Main Warehouse"
                     class="w-full h-full object-cover rounded-lg shadow-soft hover:shadow-lg transition-shadow duration-300">
            </div>

            <div>
                <img src="https://images.unsplash.com/photo-1553413077-190dd305871c?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
                     alt="Loading Dock"
                     class="w-full h-48 object-cover rounded-lg shadow-soft hover:shadow-lg transition-shadow duration-300">
            </div>

            <div>
                <img src="https://images.unsplash.com/photo-1586528116311-ad8dd3c8310d?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
                     alt="Storage Area"
                     class="w-full h-48 object-cover rounded-lg shadow-soft hover:shadow-lg transition-shadow duration-300">
            </div>

            <div>
                <img src="https://images.unsplash.com/photo-1578662996442-48f60103fc96?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
                     alt="Transport Fleet"
                     class="w-full h-48 object-cover rounded-lg shadow-soft hover:shadow-lg transition-shadow duration-300">
            </div>

            <div>
                <img src="https://images.unsplash.com/photo-1601584115197-04ecc0da31d7?ixlib=rb-4.0.3&amp;auto=format&amp;fit=crop&amp;w=2070&amp;q=80"
                     alt="Operations Center"
                     class="w-full h-48 object-cover rounded-lg shadow-soft hover:shadow-lg transition-shadow duration-300">
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-16 bg-gradient-to-r from-horizon-700 to-horizon-800 text-white">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <div class="max-w-3xl mx-auto">
            <h2 class="font-display text-3xl md:text-4xl font-bold mb-4">
                Ready to Partner with {{$settings->site_name}}?
            </h2>
            <p class="text-lg mb-8 text-gray-200">
                Join thousands of satisfied customers who trust us with their logistics needs
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="contact"
                   class="inline-flex items-center justify-center px-8 py-3 bg-gold-500 hover:bg-gold-600 text-horizon-800 font-semibold rounded-lg transition-colors duration-200">
                    Contact Us Today
                    <i class="fas fa-arrow-right ml-2"></i>
                </a>
                <a href="services"
                   class="inline-flex items-center justify-center px-8 py-3 border-2 border-white text-white hover:bg-white hover:text-horizon-800 font-semibold rounded-lg transition-colors duration-200">
                    View Our Services
                    <i class="fas fa-eye ml-2"></i>
                </a>
            </div>
        </div>
    </div>
</section>

<script src="https://unpkg.com/alpinejs%403.14.9/dist/cdn.min.js" defer></script>
        </div>
    </main>




@endsection
