@extends('layouts.app')

@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')

    <div class="main-panel">


        <div class="content">
              <style>
    .marquee-container {
      background-color: #fff3cd;
      color: #856404;
      border: 1px solid #ffeeba;
      padding: 10px 20px;
      font-family: Arial, sans-serif;
      font-size: 16px;
      position: relative;
      overflow: hidden;
      height: 50px;
    }

    .marquee-text {
      white-space: nowrap;
      display: inline-block;
      animation: marquee 15s linear infinite;
    }

    @keyframes marquee {
      0% { transform: translateX(100%); }
      100% { transform: translateX(-100%); }
    }
  </style>
   <div class="marquee-container">
    <div class="marquee-text">
      🚨 Note: To turn on Customs Clearance Document Required Notification you need to update shipment status to Customs
    </div>
  </div>

            <div class="page-inner">

                <div class="mt-2 mb-4 d-flex justify-content-between align-items-center">
                    <h4>Add New Update</h4>
                    <a class="btn btn-primary btn-sm" href="{{ route('couriers.index') }}">
                        <i class="fa fa-arrow-left"></i> back
                    </a>
                </div>

                <x-danger-alert />
                <x-success-alert />

              <h2>Tracking: {{ $courier->tracking_code }}</h2>

<p><strong>Sender:</strong> {{ $courier->sender_name }} | <strong>Receiver:</strong> {{ $courier->receiver_name }}</p>
<p><strong>Status:</strong> {{ $courier->status }} | <strong>Location:</strong> {{ $courier->current_location }}</p>

@if($courier->photo)
    <img src="{{ asset('storage/app/public/' . $courier->photo) }}" width="200">
@endif

<hr>

@include('admin.couriers.partials.update_form', ['courier' => $courier])
@include('admin.couriers.partials.tracking_history', ['updates' => $courier->updates])

            </div>
        </div>
    </div>
@endsection
