<form action="{{ route('courier.updates.store', $courier->id) }}" method="POST">
    @csrf
    <h4>Add Shipment Update</h4>

    <div class="mb-2">
        <label>Status:</label>
         @php
    $statuses = [
        'Approved', 'Available', 'Cancelled', 'Customs', 'Delivered', 'Dispenser',
        'Distribution', 'Earring Collection', 'Effective', 'In Transit', 'In warehouse',
        'Invoiced', 'On Hold', 'On route', 'Packaged', 'Pending'
    ];
    $selectedStatus = old('status', $courier->status ?? '');
@endphp

<select name="status" class="form-control" required>
    @foreach ($statuses as $status)
        <option value="{{ $status }}" {{ $selectedStatus === $status ? 'selected' : '' }}>
            {{ $status }}
        </option>
    @endforeach
</select>
    </div>

    <div class="mb-2">
        <label>Location:</label>
        <input type="text" name="location" class="form-control" placeholder="e.g. Lagos, Nigeria" required>
    </div>

    <div class="mb-2">
        <label>Comment:</label>
        <textarea name="comment" class="form-control" placeholder="Optional note..."></textarea>
    </div>

    <button type="submit" class="btn btn-primary">Submit Update</button>
</form>

