<h4 class="mt-4">Tracking History</h4>

@if($updates->count())
    @foreach ($updates->sortByDesc('created_at') as $update)
        <div class="border p-2 mb-2 bg-light rounded shadow-sm">
            <strong>{{ $update->status }}</strong><br>
            <span class="text-muted">{{ $update->location }}</span><br>
            <small class="text-secondary">{{ $update->created_at->format('d M Y, h:i A') }}</small><br>
            @if($update->comment)
                <div><em>{{ $update->comment }}</em></div>
            @endif
        </div>
    @endforeach
@else
    <p class="text-muted">No updates yet.</p>
@endif
