@extends('layouts.app')

@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')

    <div class="main-panel">
        <div class="content">
            <div class="page-inner mt-2 mb-4">
                <div class="d-flex justify-content-between align-items-center mb-3">
                    <h2>Create Shipments</h2>
                    <a class="btn btn-primary btn-sm" href="{{ route('couriers.index') }}">
                        <i class="fa fa-arrow-left"></i> Back
                    </a>
                </div>

                <x-danger-alert />
                <x-success-alert />
                @if ($errors->any())
    <div class="alert alert-danger">
        <ul class="mb-0">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif




                <form action="{{ route('couriers.store') }}" method="POST" enctype="multipart/form-data">
                    @include('admin.couriers.form')
                </form>
            </div>
        </div>
    </div>
@endsection
