<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Courier extends Model
{
    protected $fillable = [
        'tracking_code', 'sender_name', 'sender_email', 'sender_address',
        'receiver_name', 'receiver_email', 'receiver_contact', 'receiver_address',
        'delivery_completion', 'description', 'quantity', 'weight', 'status',
        'shipment_progress', 'origin', 'current_location', 'destination',
        'freight_cost', 'estimated_delivery', 'dispatch_date', 'photo','payment_mode', 'shipping_mode'
    ];

    public function updates()
    {
        return $this->hasMany(CourierUpdate::class);
    }
}
