<?php



namespace App\Mail;

use App\Models\Courier;
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class CourierCreated extends Mailable
{
    use Queueable, SerializesModels;

    public $courier;

    public function __construct(Courier $courier)
    {
        $this->courier = $courier;
    }

    public function build()
    {
        return $this->subject('Your Shipment Has Been Created')
                   ->markdown('emails.couriers.courier_created');
    }
}
// This class handles the email notification when a new courier is created.
// It uses the Mailable class to define the email structure and content.
// The `build` method sets the email subject and specifies the Markdown template to use for the email body.
// The `__construct` method accepts a Courier model instance, which contains the details of
