<?php
include 'db.php';
include 'config.php';


?>
<!doctype html>
<html class="no-js" lang="en">

<!--   23:54:54 GMT -->

<head>
  	<meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">
		<meta http-equiv="X-UA-Compatible" content="IE=edge">
        
		<!-- TITLE -->
		<title>Track & Trace - </title>
        
        <!-- FONT AWESOME ICONS LIBRARY -->
        <link rel="stylesheet" href="fonts/css/all.min.css">  
        
        <!--  FAVICON  -->
        <link rel="shortcut icon" href="img/master/favicon.png">
        
        <!-- BOOTSTRAP FRAMEWORK STYLES -->
        <link rel="stylesheet" href="css/bootstrap.min.css">
        
        <!-- MAIN CSS STYLE SHEET -->
        <link rel="stylesheet" href="css/custom.css">
        <link rel="stylesheet" href="css/stylesheet.css">
        <link rel="stylesheet" href="css/navbar.css">
        <link rel="stylesheet" href="css/responsive.css">
        <link rel="stylesheet" href="css/slick.min.css"> 
        <link rel="stylesheet" href="css/owl.carousel.min.css">

         <link href="bootstrap.min.css" rel="stylesheet">
        <link href="track/style.css" rel="stylesheet">

        <!-- MODERNIZR LIBRARY -->
        <script src="js/modernizr-custom.js"></script>

      <!-- CSS here -->
    <!-- <link rel="stylesheet" href="trackcss/bootstrap.min.css"> -->
    <link rel="stylesheet" href="trackcss/root.css">
    <!-- <link rel="stylesheet" href="trackcss/animate.min.css">
    <link rel="stylesheet" href="trackcss/magnific-popup.css"> -->
    <!-- <link rel="stylesheet" href="trackcss/fontawesome-all.min.css">
    <link rel="stylesheet" href="trackcss/aos.css">
    <link rel="stylesheet" href="trackcss/nice-select.css">
    <link rel="stylesheet" href="trackcss/flaticon.css"> -->
    <!-- <link rel="stylesheet" href="trackcss/meanmenu.css"> -->
    <!-- <link rel="stylesheet" href="trackcss/slick.css"> -->
    <!-- <link rel="stylesheet" href="trackcss/default.css"> -->
    <!--<link rel="stylesheet" href="trackcss/style.css">-->
    <!-- <link rel="stylesheet" href="trackcss/responsive.css"> -->
    
</head>

<body>

    <!-- PRELOADER START -->
    <div id="loader-wrapper">
        <div class="loader">
           <div class="ball"></div>
           <div class="ball"></div>
           <div class="ball"></div>
           <div class="ball"></div>
           <div class="ball"></div>
           <div class="ball"></div>
           <div class="ball"></div>
           <div class="ball"></div>
           <div class="ball"></div>
           <div class="ball"></div>
        </div> 
    </div>
    <!-- PRELOADER END -->
    
    <header>
        <!-- TOP HEADER START -->
        <div class="top-header-wrapper">
            <div class="container">
                <div class="row">
                    <div class="col-md-6">
                        <ul class="top-contact text-left">
                            <li class="mail"><a href="mailto:info@cargoy.com">info@cargoy.com</a></li>
                            <li class="phone"><span class="tel-no"><a href="tel:052-5401-3322"> 052 5401 3322</a></span></li>
                        </ul>
                    </div>
                    <div class="col-md-6 text-right">
                        <div class="top-social">
                            <ul class="social-list">
                                <li><a href="#"><i class="fab fa-facebook-f"></i></a></li>
                                <li><a href="#"><i class="fab fa-twitter"></i></a></li>
                                <li><a href="#"><i class="fab fa-instagram"></i></a></li>
                                <li><a href="#"><i class="fab fa-linkedin-in"></i></a></li>
                                <li style="background-color: #b4e602;" class="m-0"><a class="btn quote-btn" href="quote-request.html" role="button">GET A QUOTE</a></li>
                            </ul>
                        </div>
                    </div>
                </div>
                <hr class="top-header-line">
            </div>
        </div>
        <!-- TOP HEADER END -->
        
         <!-- NAV START -->
        <nav class="navbar navbar-expand-lg navbar-dark">
            <div class="container p-0">
                <a href="#" class="navbar-brand"><img src="img/master/logo.png" alt=""></a>

                <button type="button" class="navbar-toggler collapsed" data-toggle="collapse" data-target="#main-nav">
                    <span class="menu-icon-bar"></span>
                    <span class="menu-icon-bar"></span>
                    <span class="menu-icon-bar"></span>
                </button>

                <div id="main-nav" class="collapse navbar-collapse">
                    <ul class="navbar-nav ml-auto">
                        <li class="dropdown">
                            <a href="index.html" class="nav-item nav-link" >HOME</a>
                            <!-- <div class="dropdown-menu">
                                <a href="homepage-one.html" class="dropdown-item">Homepage One</a>
                                <a href="homepage-two.html" class="dropdown-item">Homepage Two</a>
                                <a href="homepage-three.html" class="dropdown-item">Homepage Three</a>
                            </div> -->
                        </li>
                        <li class="dropdown">
                            <a href="#" class="nav-item nav-link" data-toggle="dropdown">Pages</a>
                            <div class="dropdown-menu">
                                <!-- <a href="gallery.html" class="dropdown-item">Gallery</a>
                                <a href="careers.html" class="dropdown-item">Careers</a>
                                <a href="pricing.html" class="dropdown-item">Pricing</a> -->
                                <a href="team.html" class="dropdown-item">Our Team</a>
                                <a href="faq.html" class="dropdown-item">FAQ</a>
                                <!-- <a href="quote-request.html" class="dropdown-item">Quote Request</a>
                                <a href="404-error.html" class="dropdown-item">404 Page</a> -->
                            </div>
                        </li>
                        <li class="dropdown">
                            <a href="about-us-one.html" class="nav-item nav-link">ABOUT</a>
                            <!-- <div class="dropdown-menu">
                                <a href="about-us-one.html" class="dropdown-item">About Us One</a>
                                <a href="about-us-two.html" class="dropdown-item">About Us Two</a>
                            </div> -->
                        </li>
                        <li class="dropdown">
                            <a href="#" class="nav-item nav-link" data-toggle="dropdown">Transport</a>
                            <div class="dropdown-menu">
                                <a href="air-transport.html" class="dropdown-item">Air Freight</a>
                                <a href="ground-transport.html" class="dropdown-item">Ground Freight</a>
                                <a href="maritime-transport.html" class="dropdown-item">Maritime Freight</a>
                                <a href="railway-transport.html" class="dropdown-item">Railway Freight</a>
                                <a href="home-delivery.html" class="dropdown-item">Home Delivery</a>
                            </div>
                        </li>

                       
                               <li>  <a href="track.php" class="nav-item nav-link">Track</a></li>
                       

                        <!-- <li class="dropdown">
                            <a href="#" class="nav-item nav-link" data-toggle="dropdown">Blog</a>
                            <div class="dropdown-menu">
                                <a href="blog-grid.html" class="dropdown-item">Blogs Grid</a>
                                <a href="blog-left-sidebar.html" class="dropdown-item">Blogs Left Sidebar</a>
                                <a href="blog-right-sidebar.html" class="dropdown-item">Blogs Right Sidebar</a>
                                <a href="blog-single.html" class="dropdown-item">Blog Single</a>
                            </div>
                        </li> -->
                        <li class="dropdown">
                            <a href="contact-us-one.html" class="nav-item nav-link border-0">Contact</a>
                            <!-- <div class="dropdown-menu">
                                <a href="contact-us-one.html" class="dropdown-item">Contact Us One</a>
                                <a href="contact-us-two.html" class="dropdown-item">Contact Us Two</a>
                                <a href="contact-us-three.html" class="dropdown-item">Contact Us Three</a>
                            </div> -->
                        </li>
                    </ul>
                </div>
            </div>
        </nav>
        <!-- NAV END -->
    </header>
    
    <div class="pages-hero">
        <div class="container">
            <div class="pages-title">
                <h1>Track & Trace</h1>
                <div class="page-nav">
                    <p><a href="#">Home</a> &nbsp; | &nbsp; <a href="#">Track & Trace</a></p>
                </div>
            </div>
            
        </div>  
    </div>


   


<section class="subscribe-section p-0">
        <div class="auto-container">
            <div class="outer-box wow fadeInLeft">
                <div class="icon-arrow-2"></div>
                <div class="icon-block"></div>
                <div class="title-box">
                    <h3 class="title">Track & Trace</h3>
                </div>
                <div class="subscribe-form">
                    <form action="track.php" method="POST">
                        <div class="row">
                            <div class="form-group col-lg-10 col-md-10">
                                <div class="input-outer">
                                    <i class="icon fal fa-user"></i>
                                    <input type="text" name="tracking_number" placeholder="Your Tracking ID Now" required>
                                </div>
                            </div>

                            <div class="form-group col-lg-2 col-md-2">
                                <button class="theme-btn btn-style-one" name="tracking_number_submit" style="background-color: #b4e602;"><span class="btn-title">Track
                                        Order</span></button>
                            </div>
                        </div>
                    </form>
                </div>
                
                
            </div>
        </div>
    </section>


        <?php
        if (isset($_POST['tracking_number'])) {
            $tracking_number = mysqli_real_escape_string($link, $_POST['tracking_number']);

            $sql = "SELECT * FROM tracking WHERE tracking_number='$tracking_number';";
            $result = mysqli_query($link, $sql);
            $row = mysqli_fetch_assoc($result);
            $numrows = mysqli_num_rows($result);
            if ($numrows > 0) {
        ?>

                <!-- about-area -->
                <section class="about-area about-bg">
                    <div class="auto-container">
                        <div class="row">
                            <div class="col-12">
                                <div class="tracking-bar-section">
                                    <?php
                                    $sql1 = "SELECT * FROM track_update WHERE track_num='$tracking_number';";
                                    $result1 = mysqli_query($link, $sql1);
                                    $numrows1 = mysqli_num_rows($result1);
                                    $num1 = 1;
                                    $color_progress_bar = true;
                                    if ($numrows1 > 0) {
                                        while ($row1 = mysqli_fetch_assoc($result1)) {
                                    ?>
                                            <div class="box <?php if ($color_progress_bar == true) {
                                                                echo "active";
                                                            } ?>">
                                                <div class="progress-container">
                                                    <div class="middle-circle"><?php echo $num1; ?></div>
                                                </div>
                                                <div class="details">
                                                    <div class="status"><?php echo $row1['status'] ?> in <?php echo $row1['current_location'] ?></div>
                                                    <div class="note"><?php echo $row1['note'] ?></div>
                                                    <div class="date"><?php echo date('F dS, Y', strtotime($row1['date'])); ?></div>
                                                </div>
                                            </div>
                                            <!-- <div class="box active">
                                                <div class="progress-container">
                                                    <div class="middle-circle">2</div>
                                                </div>
                                                <div class="note">Picked by courier</div>
                                                <div class="date">September 14th, 2023</div>
                                            </div>
                                            <div class="box">
                                                <div class="progress-container last">
                                                    <div class="middle-circle">3</div>
                                                </div>
                                                <div class="note">On the way</div>
                                                <div class="date">September 14th, 2023</div>
                                            </div>
                                            <div class="box">
                                                <div class="progress-container last">
                                                    <div class="middle-circle">4</div>
                                                </div>
                                                <div class="note">Ready for pickup</div>
                                                <div class="date">September 14th, 2023</div>
                                            </div> -->

                                    <?php
                                            if ($row1['is_current_location'] == "yes") {
                                                $color_progress_bar = false;
                                            }
                                            $num1++;
                                        }
                                    }
                                    ?>



                                </div>


                            </div>
                        </div>
                    </div>
                </section>
                <!-- about-area-end -->



                <!-- bar code -container start -->
                <section class="services-area">
                    <div class="auto-container">
                        <div class="bar-code-container">
                            <div class="logo-container">
                                <img src="uploads/<?php echo $site_logo; ?>" alt="" class="logo">
                            </div>
                            <div style="display:flex;justify-content:center;margin:20px 0px;">
                                <img id="barcode" style="width:150px;height:auto;">
                            </div>
                        </div>
                    </div>
                </section>
                <!-- bar code container end -->


                <!-- sender and receiver -container start -->
                <section class="services-area">
                    <div class="auto-container">
                        <div class="sender-and-receiver-container">
                            <div class="row">
                                <div class="col-lg-6">
                                    <h5>Shipper Information</h5>
                                    <p>Name: <?php echo $row['sender_name']; ?></p>
                                    <p>Address: <?php echo $row['sender_address']; ?></p>
                                    <p>Phone Number: <?php echo $row['sender_contact']; ?></p>
                                    <p>Email: <?php echo $row['sender_email']; ?></p>
                                </div>
                                <div class="col-lg-6">
                                    <h5>Receiver Information</h5>
                                    <p>Name: <?php echo $row['receiver_name']; ?></p>
                                    <p>Address: <?php echo $row['receiver_address']; ?></p>
                                    <p>Phone Number: <?php echo $row['receiver_contact']; ?></p>
                                    <p>Email: <?php echo $row['receiver_email']; ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- sender and receiver container end -->



                <!-- shipment information -container start -->
                <section class="services-area">
                    <div class="auto-container">
                        <div class="shipment-information-container">
                            <div style="background-color: #0a295c;" class="section-title">SHIPMENT STATUS - <?php echo $row['status']; ?></div>
                            <div class="image-container">
                                <img src="uploads/<?php echo $row['image']; ?>" alt="" class="image">
                            </div>
                            <div class="row">
                                <div class="col-lg-3">
                                    <h6>Origin:</h6>
                                    <p><?php echo $row['dispatch_location']; ?></p>

                                    <h6>Carrier:</h6>
                                    <p><?php echo $row['carrier']; ?></p>

                                    <h6>Carrier Reference No:</h6>
                                    <p><?php echo $row['carrier_ref']; ?></p>

                                    
                                </div>
                                <div class="col-lg-3">
                                    <h6>Package:</h6>
                                    <p><?php echo $row['pdesc']; ?></p>

                                
                            <h6>Total Freight:</h6>
                                    <p><?php echo $row['quantity']; ?></p>
                                 

                                    <h6>Expected Delivery Date:</h6>
                                    <p><?php echo $row['delivery_date']; ?></p>
                                </div>
                                <div class="col-lg-3">
                                    <h6>Status:</h6>
                                    <p><?php echo $row['status']; ?></p>

                                    <h6>Weight:</h6>
                                    <p><?php echo $row['weight']; ?></p>

                                    

                                    <h6>Departure Date:</h6>
                                    <p><?php echo $row['dispatch_date']; ?></p>
                                </div>
                                <div class="col-lg-3">
                                    <h6>Destination:</h6>
                                    <p><?php echo $row['destination']; ?></p>

                                    <h6>Shipment Mode:</h6>
                                    <p><?php echo $row['ship_mode']; ?></p>

                                    <h6>Payment Mode:</h6>
                                    <p><?php echo $row['payment_mode']; ?></p>

                                    <h6>Delivery Time:</h6>
                                    <p><?php echo $row['delivery_time']; ?></p>
                                </div>
                            </div>
                        </div>
                    </div>
                </section>
                <!-- shipment information container end -->


                <!-- google maps -container start -->
                <?php
                if ($show_map == "Yes") {
                    $sql2 = "SELECT * FROM track_update WHERE track_num= '$tracking_number' ORDER BY id DESC LIMIT 1 ";
                    $result2 = mysqli_query($link, $sql2);
                    $row2 = mysqli_fetch_assoc($result2);
                ?>
                    <section class="services-area">
                        <div class="auto-container">
                            <div class="google-maps-container">
                                <iframe class="map" src="https://maps.google.com/maps?q=<?php echo $row2['current_location'] == "" ? $row['dispatch_location'] : $row2['current_location'] ?>&amp;t=k&amp;z=13&amp;ie=UTF8&amp;iwloc=&amp;output=embed" style="border:0; width: 100%; height: 527px;"></iframe>
                            </div>
                        </div>
                    </section>
                <?php
                }
                ?>
                <!-- google maps container end -->


                <!-- print receipt container -container start -->
                <?php
                if ($allow_print == "Yes") {
                ?>
                    <section class="services-area">
                        <div class="auto-container">
                            <div class="print-receipt-container">
                                <a style="background-color: #0a295c;" href="invoice/receipt.php?tracking_number=<?php echo $tracking_number; ?>" class="print-receipt-btn">Print Receipt</a>
                            </div>
                        </div>
                    </section>
                <?php
                }
                ?>
                <!-- print receipt container container end -->

        <?php
            } else {
                echo "<script>alert('Invalid Tracking Number');window.location.href = 'track.php'; </script>";
            }
        }
        ?>


            <br>




          <!-- FOOTER START -->
    <footer>
        <div class="main-footer">
            <div class="container">
                <div class="row">
                    <div class="col-lg-4">
                        <div class="layer-info">
                            <figure class="footer-logo">
                                <img src="img/master/logo.png" alt="">
                            </figure>
                            <p>
                                Welcome to Quick Route! We provide fast and reliable logistics and 
                                courier services, ensuring your packages arrive safely and on time.
                                 With a focus on efficiency and customer 
                                satisfaction, we're your trusted partner for all your delivery needs</p>
                            <hr class="footer">
                            <ul class="layer-contact mt-3">
                                <li class="phone"><span class="tel-no"><a href="tel:052-5401-3322"> 052 5401 3322</a></span></li>
                                <li class="email"><a href="mailto:info@cargoy.com"> info@cargoy.com</a></li>
                                <li class="address">33195 NW 56th ST Miami, Florida</li>
                            </ul>
                            <div class="social-footer mt-4">
                                <ul>
                                   <li><a href="#"><i class="fab fa-facebook-f"></i></a></li> 
                                   <li><a href="#"><i class="fab fa-twitter"></i></a></li> 
                                   <li><a href="#"><i class="fab fa-instagram"></i></a></li> 
                                   <li><a href="#"><i class="fab fa-linkedin-in"></i></a></li> 
                                </ul>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-4 footer-col">
                        <h5 class="layer-title">Transportation</h5>
                        <div class="layer-services">
                            <ul class="left-side">
                                <li><a href="air-transport.html">Air Freight</a></li>
                                <li><a href="ground-transport.html">Ground Freight</a></li>
                                <li><a href="maritime-transport.html">Maritime Freight</a></li>
                            </ul>
                            <ul class="right-side">
                                <li><a href="railway-transport.html">Railway Freight </a></li>
                                <li><a href="home-delivery.html">Home Delivery</a></li>
                            </ul>
                        </div>
                        <div class="clearfix"></div>
                        <h5 class="layer-title mt-4">Newsletter</h5>
                        <p class="subscribe">Subscribe to our newsletter to receive the latest news about our services.</p>
                        <div class="newsletter mt-4">
                            <form  action="#" method="post" name="sign-up">
                                <input type="email" class="input" id="email" name="email" placeholder="Your email address" required>
                                <input type="submit" class="button" id="submit" value="SIGN UP">
                            </form> 
                        </div>
                    </div>
                    <div class="col-lg-4 news-layer">
                        <h5 class="layer-title">Latest News</h5>
                        <div class="media">
                          <img src="img/images/blog-thumb-footer-3.jpg" class="mr-3" alt="...">
                          <div class="media-body">
                            <h6 class="mt-0"><a href="#">Logistics Firms Aim to Keep Goods Moving Economy Closes</a></h6>
                            <p>April 1, 2020</p>
                          </div>
                        </div>
                        <hr class="media">
                        <div class="media mt-3">
                          <img src="img/images/blog-thumb-footer-2.jpg" class="mr-3" alt="...">
                          <div class="media-body">
                            <h6 class="mt-0"><a href="#">Shipping Survival Mode Crushing the Margins.</a></h6>
                            <p>March 31, 2020</p>
                          </div>
                        </div>
                        <hr class="media">
                        <div class="media">
                          <img src="img/images/blog-thumb-footer-1.jpg" class="mr-3" alt="...">
                          <div class="media-body">
                            <h6 class="mt-0"><a href="#">Passenger Airlines Start Shifting Idled Planes.</a></h6>
                            <p>March 29, 2020</p>
                          </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="bottom-footer">
            <div class="container">                        
                <div class="row">
                    <div class="col-md-6">
                        <div class="copyright"><p>Copyright © 2024&nbsp;<a href="#">QuickRoute
</a></p></div>
                    </div>
                    <div class="col-md-6">
                        <ul class="footer-nav">
                            <li><a href="about-us-one.html">About Us</a></li>
                            <li class="center-nav-item"><a href="#">Privacy Policy</a></li>
                            <li><a href="contact-us-one.html">Contact</a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <!-- FOOTER END -->
    
    <!--SCROLL TOP START-->
    <a style='background-color: #0a295c' href="#0" class="cd-top">Top</a>
    <!--SCROLL TOP START-->

    <!-- JAVASCRIPTS -->
    <script src="js/jquery-3.4.1.min.js"></script>
    <script src="js/plugins.js"></script>
    <script src="js/bootstrap.min.js"></script>
    <script src="js/main.js"></script>
    <script src="js/nav-fixed-top.js"></script>

        <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyCo_pcAdFNbTDCAvMwAD19oRTuEmb9M50c"></script>

    <script src="trackjs/JsBarcode.all.min.js"></script>
        <script>
            JsBarcode("#barcode", "<?php echo $tracking_number; ?>");
        </script>
    <!-- JAVASCRIPTS END -->
    
    
        
<!-- WhatsHelp.io widget -->
<script type="text/javascript">
    (function () {
        var options = {
            whatsapp: "1234567890", // WhatsApp number
            call_to_action: "Message us", // Call to action
            position: "left", // Position may be 'right' or 'left'
        };
        var proto = document.location.protocol, host = "getbutton.io", url = proto + "//static." + host;
        var s = document.createElement('script'); s.type = 'text/javascript'; s.async = true; s.src = url + '/widget-send-button/js/init.js';
        s.onload = function () { WhWidgetSendButton.init(host, proto, options); };
        var x = document.getElementsByTagName('script')[0]; x.parentNode.insertBefore(s, x);
    })();
</script>
<!-- /WhatsHelp.io widget -->


</body>

<!--   23:57:06 GMT -->

</html>